<?php
/* vim: set expandtab tabstop=4 softtabstop=4 shiftwidth=4:
  Codificación: UTF-8
  +----------------------------------------------------------------------+
  | Issabel version 0.8                                                  |
  | http://www.issabel.org                                               |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006 Palosanto Solutions S. A.                         |
  +----------------------------------------------------------------------+
  | The contents of this file are subject to the General Public License  |
  | (GPL) Version 2 (the "License"); you may not use this file except in |
  | compliance with the License. You may obtain a copy of the License at |
  | http://www.opensource.org/licenses/gpl-license.php                   |
  |                                                                      |
  | Software distributed under the License is distributed on an "AS IS"  |
  | basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See  |
  | the License for the specific language governing rights and           |
  | limitations under the License.                                       |
  +----------------------------------------------------------------------+
  | The Initial Developer of the Original Code is PaloSanto Solutions    |
  +----------------------------------------------------------------------+
  $Id: default.conf.php,v 1.1.1.1 2007/03/23 00:13:58 elandivar Exp $ */


//require_once "modules/agent_console/libs/issabel2.lib.php";
//require_once "modules/agent_console/libs/JSON.php";
//require_once "modules/agent_console/libs/paloSantoConsola.class.php";

function _moduleContent(&$smarty, $module_name)
{
    global $arrConf;
    global $arrLang;
    global $arrConfig;

    require_once "modules/$module_name/libs/issabel2.lib.php";
    require_once "modules/$module_name/libs/JSON.php";
    require_once "modules/$module_name/libs/paloSantoConsola.class.php";

    //include module files
    include_once "modules/$module_name/configs/default.conf.php";

    // Se fusiona la configuración del módulo con la configuración global
    $arrConf = array_merge($arrConf, $arrConfModule);

    load_language_module($module_name);

    //folder path for custom templates
    $base_dir = dirname($_SERVER['SCRIPT_FILENAME']);
    $templates_dir = (isset($arrConfig['templates_dir']))?$arrConfig['templates_dir']:'themes';
    $local_templates_dir = "$base_dir/modules/$module_name/".$templates_dir.'/'.$arrConf['theme'];

    // Ember.js requiere jQuery 1.7.2 o superior.
    modificarReferenciasLibreriasJS($smarty);

    $sContenido = '';

    // Procesar los eventos AJAX.
    switch (getParameter('action')) {
        case 'getCampaigns':
            $sContenido = manejarMonitoreo_getCampaigns($module_name, $smarty, $local_templates_dir);
            break;
        case 'getCampaignDetail':
            $sContenido = manejarMonitoreo_getCampaignDetail($module_name, $smarty, $local_templates_dir);
            break;
        case 'checkStatus':
            $sContenido = manejarMonitoreo_checkStatus($module_name, $smarty, $local_templates_dir);
            break;
         case 'blacklist':
            $sContenido = manejarSesionActiva_blacklist();
            break;
        case 'contact_found':
            $sContenido = manejarSesionActiva_contact_found();
            break;
        default:
            // Página principal con plantilla
            $sContenido = manejarMonitoreo_HTML($module_name, $smarty, $local_templates_dir);
    }
    return $sContenido;
}

function manejarMonitoreo_HTML($module_name, $smarty, $sDirLocalPlantillas)
{
    $smarty->assign("MODULE_NAME", $module_name);
    $smarty->assign(array(
        'title'                         =>  _tr('Campaign Monitoring'),
        'icon'                          => '/images/list.png',
        'ETIQUETA_CAMPANIA'             =>  _tr('Campaign'),
        'ETIQUETA_FECHA_INICIO'         =>  _tr('Start date'),
        'ETIQUETA_FECHA_FINAL'          =>  _tr('End date'),
        'ETIQUETA_HORARIO'              =>  _tr('Schedule'),
        'ETIQUETA_COLA'                 =>  _tr('Queue'),
        'ETIQUETA_INTENTOS'             =>  _tr('Retries'),
        'ETIQUETA_TOTAL_LLAMADAS'       =>  _tr('Total calls'),
        'ETIQUETA_LLAMADAS_PENDIENTES'  =>  _tr('Pending calls'),
        'ETIQUETA_LLAMADAS_FALLIDAS'    =>  _tr('Failed calls'),
        'ETIQUETA_LLAMADAS_CORTAS'      =>  _tr('Short calls'),
        'ETIQUETA_LLAMADAS_EXITO'       =>  _tr('Connected calls'),
        'ETIQUETA_LLAMADAS_MARCANDO'    =>  _tr('Placing calls'),
        'ETIQUETA_LLAMADAS_COLA'        =>  _tr('Queued calls'),
        'ETIQUETA_LLAMADAS_TIMBRANDO'   =>  _tr('Ringing calls'),
        'ETIQUETA_LLAMADAS_ABANDONADAS' =>  _tr('Abandoned calls'),
        'ETIQUETA_LLAMADAS_NOCONTESTA'  =>  _tr('Unanswered calls'),
        'ETIQUETA_LLAMADAS_TERMINADAS'  =>  _tr('Finished calls'),
        'ETIQUETA_LLAMADAS_SINRASTRO'   =>  _tr('Lost track'),
        'ETIQUETA_AGENTES'              =>  _tr('Ramais'),
        'ETIQUETA_NUMERO_TELEFONO'      =>  _tr('Phone Number'),
        'ETIQUETA_TRONCAL'              =>  _tr('Trunk'),
        'ETIQUETA_ESTADO'               =>  _tr('Status'),
        'ETIQUETA_DESDE'                =>  _tr('Since'),
        'ETIQUETA_AGENTE'               =>  _tr('Ramal'),
        'ETIQUETA_REGISTRO'             =>  _tr('View campaign log'),
        'PREVIOUS_N'                    =>  _tr('Previous 100 entries'),
        'ETIQUETA_MAX_DURAC_LLAM'       =>  _tr('Maximum Call Duration'),
        'ETIQUETA_PROMEDIO_DURAC_LLAM'  =>  _tr('Average Call Duration'),
    ));

    return $smarty->fetch("file:$sDirLocalPlantillas/console.tpl");
}

function manejarMonitoreo_getCampaigns($module_name, $smarty, $sDirLocalPlantillas)
{
    $respuesta = array(
        'status'    =>  'success',
        'message'   =>  '(no message)',
    );

    $oPaloConsola = new PaloSantoConsola();  
    $listaCampanias = $oPaloConsola->leerListaCampanias();
   
    if (!is_array($listaCampanias)) {
    	$respuesta['status'] = 'error';
        $respuesta['message'] = $oPaloConsola->errMsg;
    }
    /*
    $listaColas = $oPaloConsola->leerListaColasEntrantes();
    if (!is_array($listaColas)) {
        $respuesta['status'] = 'error';
        $respuesta['message'] = $oPaloConsola->errMsg;
    }
    */
    
    //if (is_array($listaCampanias) && is_array($listaColas)) {
    if (is_array($listaCampanias)) {    
        /*
        foreach ($listaColas as $q) {
        	$listaCampanias[] = array(
                'id'        =>  $q['queue'],
                'type'      =>  'incomingqueue',
                'name'      =>  $q['queue'],
                'status'    =>  $q['status'],
            );
        }
        */

        /* Para la visualización se requiere que primero se muestren las campañas
         * activas, con el ID mayor primero (probablemente la campaña más reciente)
         * seguido de las campañas inactivas, y luego las terminadas */
        if (!function_exists('manejarMonitoreo_getCampaigns_sort')) {
            function manejarMonitoreo_getCampaigns_sort($a, $b)
            {
            	if ($a['type'] != $b['type']) {
            		if ($a['type'] == 'incomingqueue') return 1;
                    if ($b['type'] == 'incomingqueue') return -1;
            	}
                if ($a['status'] != $b['status'])
                    return strcmp($a['status'], $b['status']);
                return $b['id'] - $a['id'];
            }
        }
        
       // usort($listaCampanias, 'manejarMonitoreo_getCampaigns_sort');
        
        $respuesta['campaigns'] = array();
        foreach ($listaCampanias as $c) {
            $respuesta['campaigns'][] = array(
                'id_campaign'   => $c['id'],
                //'desc_campaign' => '('._tr($c['type']).') '.$c['name'], // Retirar tipo de campaign
                'desc_campaign' =>  $c['name'], 
                'type'          =>  $c['type'],
                'status'        =>  $c['status'],
            );
        }
    }
    
    $json = new Services_JSON();
    Header('Content-Type: application/json');
    return $json->encode($respuesta);
}

function manejarMonitoreo_getCampaignDetail($module_name, $smarty, $sDirLocalPlantillas)
{
    $respuesta = array(
        'status'    =>  'success',
        'message'   =>  '(no message)',
    );
    $estadoCliente = array();

    $sTipoCampania = getParameter('campaigntype');
    $sIdCampania = getParameter('campaignid');
    if (is_null($sTipoCampania) || !in_array($sTipoCampania, array('incoming', 'outgoing', 'incomingqueue'))) {
        $respuesta['status'] = 'error';
        $respuesta['message'] = _tr('Invalid campaign type');
    } elseif (is_null($sIdCampania) || !ctype_digit($sIdCampania)) {
        $respuesta['status'] = 'error';
        $respuesta['message'] = _tr('Invalid campaign ID');
    } else {
        $oPaloConsola = new PaloSantoConsola();
        if ($respuesta['status'] == 'success') {
        	$infoCampania = $oPaloConsola->leerInfoCampania($sTipoCampania, $sIdCampania);
            if (!is_array($infoCampania)) {
            	$respuesta['status'] = 'error';
                $respuesta['message'] = $oPaloConsola->errMsg;
            }
        }
        if ($respuesta['status'] == 'success') {
            $estadoCampania = $oPaloConsola->leerEstadoCampania($sTipoCampania, $sIdCampania);
            if (!is_array($estadoCampania)) {
                $respuesta['status'] = 'error';
                $respuesta['message'] = $oPaloConsola->errMsg;
            }
        }
        if ($respuesta['status'] == 'success') {
        	//$logCampania = $oPaloConsola->leerLogCampania($sTipoCampania, $sIdCampania);
            $logCampania = array();
            if (!is_array($logCampania)) {
                $respuesta['status'] = 'error';
                $respuesta['message'] = $oPaloConsola->errMsg;
            }
        }
    }
    if ($respuesta['status'] == 'success') {
    	$respuesta['campaigndata'] = array(
            'startdate'                 =>
                is_null($infoCampania['startdate'])
                ? _tr('N/A') : $infoCampania['startdate'],
            'enddate'                   =>
                is_null($infoCampania['enddate'])
                ? _tr('N/A') : $infoCampania['enddate'],
            'working_time_starttime'    =>
                is_null($infoCampania['working_time_starttime'])
                ? _tr('N/A') : $infoCampania['working_time_starttime'],
            'working_time_endtime'      =>
                is_null($infoCampania['working_time_endtime'])
                ? _tr('N/A') : $infoCampania['working_time_endtime'],
            'queue'                     =>  $infoCampania['queue'],
            'retries'                   =>
                is_null($infoCampania['retries'])
                ? _tr('N/A') : (int)$infoCampania['retries'],
        );

        // Traducción de estado de las llamadas no conectadas
        $estadoCampaniaLlamadas = array();
        foreach ($estadoCampania['activecalls'] as $activecall) {
            $estadoCampaniaLlamadas[] = formatoLlamadaNoConectada($activecall);
        }

        // Traducción de estado de los agentes
        $estadoCampaniaAgentes = array();
        foreach ($estadoCampania['agents'] as $agent) {
            $estadoCampaniaAgentes[] = formatoAgente($agent);
        }

        // Traducción de log de la campaña
        $logFinalCampania = array();
        foreach ($logCampania as $entradaLog) {
        	$logFinalCampania[] = formatoLogCampania($entradaLog);
        }

        // Se arma la respuesta JSON y el estado final del cliente
        $respuesta = array_merge($respuesta, crearRespuestaVacia());
        $respuesta['statuscount']['update'] = $estadoCampania['statuscount'];
        $respuesta['stats']['update'] = $estadoCampania['stats'];
        $respuesta['activecalls']['add'] = $estadoCampaniaLlamadas;
        $respuesta['agents']['add'] = $estadoCampaniaAgentes;
        $respuesta['log'] = $logFinalCampania;
        $estadoCliente = array(
            'campaignid'    =>  $sIdCampania,
            'campaigntype'  =>  $sTipoCampania,
            'queue'         =>  $infoCampania['queue'],
            'statuscount'   =>  $estadoCampania['statuscount'],
            'activecalls'   =>  $estadoCampania['activecalls'],
            'agents'        =>  $estadoCampania['agents'],
            'stats'         =>  $estadoCampania['stats'],
        );

        $respuesta['estadoClienteHash'] = generarEstadoHash($module_name, $estadoCliente);
    }

    $json = new Services_JSON();
    Header('Content-Type: application/json');
    return $json->encode($respuesta);
}

function manejarMonitoreo_loadPreviousLogEntries($module_name, $smarty, $sDirLocalPlantillas)
{
    $respuesta = array(
        'status'    =>  'success',
        'message'   =>  '(no message)',
    );

    $sTipoCampania = getParameter('campaigntype');
    $sIdCampania = getParameter('campaignid');
    $idBefore = getParameter('beforeid');
    if (is_null($idBefore) || !ctype_digit($idBefore))
        $idBefore = NULL;
    if (is_null($sTipoCampania) || !in_array($sTipoCampania, array('incoming', 'outgoing', 'incomingqueue'))) {
        $respuesta['status'] = 'error';
        $respuesta['message'] = _tr('Invalid campaign type');
    } elseif (is_null($sIdCampania) || !ctype_digit($sIdCampania)) {
        $respuesta['status'] = 'error';
        $respuesta['message'] = _tr('Invalid campaign ID');
    } else {
        $oPaloConsola = new PaloSantoConsola();
        $logCampania = $oPaloConsola->leerLogCampania($sTipoCampania, $sIdCampania, 100, $idBefore);
        if (!is_array($logCampania)) {
            $respuesta['status'] = 'error';
            $respuesta['message'] = $oPaloConsola->errMsg;
        } else {
            // Traducción de log de la campaña
            $logFinalCampania = array();
            foreach ($logCampania as $entradaLog) {
                $logFinalCampania[] = formatoLogCampania($entradaLog);
            }

            $respuesta['log'] = $logFinalCampania;
        }
    }

    $json = new Services_JSON();
    Header('Content-Type: application/json');
    return $json->encode($respuesta);
}

function manejarSesionActiva_blacklist() {
  
    $respuesta = array(
        'action' => 'confirmed',
        'message' => _tr('Number successfully aww   dded'),
    );
                                                                    
   
    $exten = $_REQUEST['exten'];
    $number = $_REQUEST['number'];
    $callid = $_REQUEST['callid'];
    
    $oPaloConsola = new PaloSantoConsola();
    
    $bExito = $oPaloConsola->blacklist($exten, $number, $callid);

    if (!$bExito) {
        $respuesta['action'] = 'error';
        $respuesta['message'] = _tr('Error while added number') . ' - ' . $oPaloConsola->errMsg;
    }

    $json = new Services_JSON();
    Header('Content-Type: application/json');
    return $json->encode($respuesta);
}

function manejarSesionActiva_contact_found($module_name, $smarty, $sDirLocalPlantillas, $oPaloConsola) {
    
    $respuesta = array(
        'action' => 'confirmed',
        'message' => _tr('Contact successfully added'),
    );

    $exten = $_REQUEST['exten'];
    $uuid = $_REQUEST['uuid'];
    $callid = $_REQUEST['callid'];
    
    $oPaloConsola = new PaloSantoConsola();
    
    $bExito = $oPaloConsola->contact_found($exten, $uuid, $callid);

    if (!$bExito) {
        $respuesta['action'] = 'error';
        $respuesta['message'] = _tr('Error while added contact') . ' - ' . $oPaloConsola->errMsg;
    }

    $json = new Services_JSON();
    Header('Content-Type: application/json');
    return $json->encode($respuesta);
}

function manejarMonitoreo_checkStatus($module_name, $smarty, $sDirLocalPlantillas)
{
    $respuesta = array();

    ignore_user_abort(true);
    set_time_limit(0);

    // Estado del lado del cliente
    $estadoHash = getParameter('clientstatehash');
    if (!is_null($estadoHash)) {
        $estadoCliente = isset($_SESSION[$module_name]['estadoCliente'])
            ? $_SESSION[$module_name]['estadoCliente']
            : array();
    } else {
        $estadoCliente = getParameter('clientstate');
        if (!is_array($estadoCliente)) return;
    }

    // Modo a funcionar: Long-Polling, o Server-sent Events
    $sModoEventos = getParameter('serverevents');
    $bSSE = (!is_null($sModoEventos) && $sModoEventos);
    if ($bSSE) {
        Header('Content-Type: text/event-stream');
        printflush("retry: 5000\n");
    } else {
        Header('Content-Type: application/json');
    }

    // Verificar hash correcto
    if (!is_null($estadoHash) && $estadoHash != $_SESSION[$module_name]['estadoClienteHash']) {
        $respuesta['estadoClienteHash'] = 'mismatch';
        $respuesta['hashRecibido'] = $estadoHash;
        jsonflush($bSSE, $respuesta);
        return;
    }

    $oPaloConsola = new PaloSantoConsola();

    // Estado del lado del servidor
    $estadoCampania = $oPaloConsola->leerEstadoCampania($estadoCliente['campaigntype'], $estadoCliente['campaignid']);
    
    if (!is_array($estadoCampania)) {
        $respuesta['error'] = $oPaloConsola->errMsg;
        jsonflush($bSSE, $respuesta);
        $oPaloConsola->desconectarTodo();
        return;
    }

    // Acumular inmediatamente las filas que son distintas en estado
    $respuesta = crearRespuestaVacia();

    // Cuenta de estados
    foreach (array_keys($estadoCliente['statuscount']) as $k) {
        // Actualización de valores de contadores
    	if ($estadoCliente['statuscount'][$k] != $estadoCampania['statuscount'][$k]) {
    		$respuesta['statuscount']['update'][$k] = $estadoCampania['statuscount'][$k];
            $estadoCliente['statuscount'][$k] = $estadoCampania['statuscount'][$k];
    	}
    }

    // Estado de llamadas no conectadas
    foreach (array_keys($estadoCliente['activecalls']) as $k) {
    	// Llamadas que cambiaron de estado o ya no están sin agente
        if (!isset($estadoCampania['activecalls'][$k])) {
        	// Llamada ya no está esperando agente
            $respuesta['activecalls']['remove'][] = array('callid' => $estadoCliente['activecalls'][$k]['callid']);
            unset($estadoCliente['activecalls'][$k]);
        } elseif ($estadoCliente['activecalls'][$k]['callstatus'] != $estadoCampania['activecalls'][$k]['callstatus']) {
        	// Llamada ha cambiado de estado
            $respuesta['activecalls']['update'][] = formatoLlamadaNoConectada($estadoCampania['activecalls'][$k]);
            $estadoCliente['activecalls'][$k] = $estadoCampania['activecalls'][$k];
        }
    }
    foreach (array_keys($estadoCampania['activecalls']) as $k) {
    	// Llamadas nuevas
        if (!isset($estadoCliente['activecalls'][$k])) {
            $respuesta['activecalls']['add'][] = formatoLlamadaNoConectada($estadoCampania['activecalls'][$k]);
            $estadoCliente['activecalls'][$k] = $estadoCampania['activecalls'][$k];
        }
    }

    // Estado de agentes de campaña
    foreach (array_keys($estadoCliente['agents']) as $k) {
    	// Agentes que cambiaron de estado o desaparecieron (???)
        if (!isset($estadoCampania['agents'][$k])) {
        	// Agente ya no aparece (???)
            $respuesta['agents']['remove'][] = array('agent' => $estadoCliente['agents'][$k]['agentchannel']);
            unset($estadoCliente['agents'][$k]);
        } elseif ($estadoCliente['agents'][$k] != $estadoCampania['agents'][$k]) {
        	// Agente ha cambiado de estado
            $respuesta['agents']['update'][] = formatoAgente($estadoCampania['agents'][$k]);
            $estadoCliente['agents'][$k] = $estadoCampania['agents'][$k];
        }
    }
    foreach (array_keys($estadoCampania['agents']) as $k) {
        // Agentes nuevos (???)
        if (!isset($estadoCliente['agents'][$k])) {
            $respuesta['agents']['add'][] = formatoAgente($estadoCampania['agents'][$k]);
            $estadoCliente['agents'][$k] = $estadoCampania['agents'][$k];
        }
    }

    unset($estadoCampania);

    $oPaloConsola->escucharProgresoLlamada(TRUE);
    $iTimeoutPoll = $oPaloConsola->recomendarIntervaloEsperaAjax();
    do {
        $oPaloConsola->desconectarEspera();

        // Se inicia espera larga con el navegador...
        $iTimestampInicio = time();

        while (connection_status() == CONNECTION_NORMAL && esRespuestaVacia($respuesta)
            && time() - $iTimestampInicio <  $iTimeoutPoll) {

            session_commit();
            $listaEventos = $oPaloConsola->esperarEventoSesionActiva();
            if (is_null($listaEventos)) {
                $respuesta['error'] = $oPaloConsola->errMsg;
                jsonflush($bSSE, $respuesta);
                $oPaloConsola->desconectarTodo();
                return;
            }
            @session_start();

            /* Si el navegador elige otra campaña mientras se espera la primera
             * campaña, entonces esta espera es inválida, y el navegador ya ha
             * iniciado otra sesión comet. */
            if (isset($_SESSION[$module_name]) &&
                !($estadoCliente['campaigntype'] === $_SESSION[$module_name]['estadoCliente']['campaigntype'] &&
                 $estadoCliente['campaignid'] === $_SESSION[$module_name]['estadoCliente']['campaignid'])) {
                $respuesta['estadoClienteHash'] = 'invalidated';
                jsonflush($bSSE, $respuesta);
                $oPaloConsola->desconectarTodo();
                return;
            }

            $iTimestampActual = time();
            foreach ($listaEventos as $evento) {
                $sCanalAgente = isset($evento['agent_number']) ? $evento['agent_number'] : NULL;
                
                switch ($evento['event']) {
           
                case 'ramallinked':
                    
                    $callid = $evento['call_id'];
                    if (isset($estadoCliente['activecalls'][$callid])) {
                        //restarContadorLlamada($estadoCliente['activecalls'][$callid]['callstatus'], $estadoCliente, $respuesta);
                       // $respuesta['activecalls']['remove'][] = array('callid' => $estadoCliente['activecalls'][$callid]['callid']);
                       // unset($estadoCliente['activecalls'][$callid]);
                    }
                   
                    
                            
                    
                   
                        // Si el agente es uno de los de la campaña, modificar
                   // if (isset($estadoCliente['agents'][$sCanalAgente])) {
                      //  $estadoCliente['agents'][$sCanalAgente]['status'] = 'oncall';
                        $estadoCliente['agents'][$sCanalAgente]['callinfo'] = array(
                            'callnumber'    =>  $evento['phone'],
                            'uuid'          =>  $evento['uuid'],
                            'linkstart'     =>  $evento['datetime_linkstart'],
                            'trunk'         =>  $evento['trunk'],
                            'callid'        =>  $evento['call_id'],

                            // Campos que (todavía) no se usan
                            'calltype'      =>  $evento['call_type'],
                            'campaign_id'   =>  $evento['campaign_id'],
                           // 'queuenumber'   =>  $evento['queue'],
                           // 'remote_channel'=>  $evento['remote_channel'],
                            'status'        =>  $evento['status'],
                           // 'queuestart'    =>  (is_null($evento['datetime_join']) || $evento['datetime_join'] == '') ? NULL : $evento['datetime_join'],
                            'dialstart'     =>  $evento['datetime_originate'],
                            'dialend'       =>  $evento['datetime_originateresponse'],
                        );
                       
                        $attributes = array();
                        foreach($evento['call_attributes'] as $attribute)
                            $attributes[strtolower($attribute['label'])] = $attribute['value'];
                        
                        //$respuesta['agents']['update'][] = formatoAgente($estadoCliente['agents'][$sCanalAgente]);
                        $respuesta['agents']['add'][] = array(
                            'agent'         =>  $sCanalAgente ,
                            'status'        =>  'InCall',
                            'callnumber'    =>  $evento['phone'],
                            'uuid'          =>  $evento['uuid'],
                            'trunk'         =>  $evento['trunk'],
                            'desde'         =>  $evento['datetime_linkstart'],
                            'call_attributes' =>  $attributes,
                            'callid'        =>  $evento['call_id'],

                        );
                        
                       
                 //   }
                    
                    
                    break;
                    
                    case 'ramalunlinked':
                        
                       // $sCanalAgente = 5901;
                    // Si el agente es uno de los de la campaña, modificar
                    if (isset($estadoCliente['agents'][$sCanalAgente])) {
                        /* Es posible que se reciba un evento agentunlinked luego
                         * del evento agentloggedout si el agente se desconecta con
                         * una llamada activa. */
                        /*
                        if ($estadoCliente['agents'][$sCanalAgente]['status'] != 'offline') {
                            $estadoCliente['agents'][$sCanalAgente]['status'] = (
                                !is_null($estadoCliente['agents'][$sCanalAgente]['pauseinfo']) ||
                                $estadoCliente['agents'][$sCanalAgente]['onhold'])
                            ? 'paused' : 'online';
                        }*/
                        $estadoCliente['agents'][$sCanalAgente]['callinfo'] = NULL;

                       // $respuesta['agents']['update'][] = formatoAgente($estadoCliente['agents'][$sCanalAgente]);
                        
                          $respuesta['agents']['remove'][] = array(
                            'agent'         =>  $sCanalAgente,
                            'status'        =>  'Unlink',
                            'callnumber'    =>  $evento['phone'],
                            'uuid'          =>  $evento['uuid'],
                            'trunk'         =>  $evento['trunk'],
                            'desde'         =>  $evento['datetime_linkstart'],
                        );
                    }
                    
    
                    if (esEventoParaCampania($estadoCliente, $evento)) {
                        $respuesta['log'][] = formatoLogCampania(array(
                            'id'                =>  $evento['campaignlog_id'],
                            'new_status'        =>  $evento['shortcall'] ? 'ShortCall' : 'Hangup',
                            'datetime_entry'    =>  $evento['datetime_linkend'],
                            'campaign_type'     =>  $evento['call_type'],
                            'campaign_id'       =>  $evento['campaign_id'],
                            'call_id'           =>  $evento['call_id'],
                            'retry'             =>  NULL,
                            'uniqueid'          =>  NULL,
                            'trunk'             =>  NULL,
                            'phone'             =>  $evento['phone'],
                            'queue'             =>  NULL,
                            'agentchannel'      =>  $sCanalAgente,
                            'duration'          =>  $evento['duration'],
                        ));

                        agregarContadorLlamada('total', $estadoCliente, $respuesta);
                        
                        if ($evento['call_type'] == 'incoming') {
                        	restarContadorLlamada('Success', $estadoCliente, $respuesta);
                            agregarContadorLlamada('Finished', $estadoCliente, $respuesta);
                            agregarContadorLlamada('Total', $estadoCliente, $respuesta);
                            $respuesta['duration'] = $evento['duration'];
                        } else {
                        	if ($evento['shortcall']) {
                        		restarContadorLlamada('Success', $estadoCliente, $respuesta);
                                        agregarContadorLlamada('ShortCall', $estadoCliente, $respuesta);
                        	} else {
                        		// Se actualiza Finished para actualizar estadísticas
                                    agregarContadorLlamada('Finished', $estadoCliente, $respuesta);
                                    $respuesta['duration'] = $evento['duration'];
                        	}
                        }
                        if (isset($respuesta['duration'])) {
                        	$estadoCliente['stats']['total_sec'] += $respuesta['duration'];
                            if ($estadoCliente['stats']['max_duration'] < $respuesta['duration'])
                                $estadoCliente['stats']['max_duration'] = $respuesta['duration'];
                        }
                    }
                    break;    
   
           
                }
            }
        }

        $estadoHash = generarEstadoHash($module_name, $estadoCliente);
        $respuesta['estadoClienteHash'] = $estadoHash;
        jsonflush($bSSE, $respuesta);

        $respuesta = crearRespuestaVacia();

    } while ($bSSE && connection_status() == CONNECTION_NORMAL);
    $oPaloConsola->desconectarTodo();
}

function esEventoParaCampania(&$estadoCliente, &$evento)
{
    return ($estadoCliente['campaigntype'] == 'incomingqueue')
        ? ( $estadoCliente['campaignid'] == $evento['queue'] &&
            is_null($evento['campaign_id']))
        : ( $estadoCliente['campaignid'] == $evento['campaign_id'] &&
            $estadoCliente['campaigntype'] == $evento['call_type']);
}

function crearRespuestaVacia()
{
    return array(
        'statuscount'   =>  array('update' => array()),
        'activecalls'   =>  array('add' => array(), 'update' => array(), 'remove' => array()),
        'agents'        =>  array('add' => array(), 'update' => array(), 'remove' => array()),
        'log'           =>  array(),
    );
}

function esRespuestaVacia(&$respuesta)
{
	return count($respuesta['statuscount']['update']) == 0
        && count($respuesta['activecalls']['add']) == 0
        && count($respuesta['activecalls']['update']) == 0
        && count($respuesta['activecalls']['remove']) == 0
        && count($respuesta['agents']['add']) == 0
        && count($respuesta['agents']['update']) == 0
        && count($respuesta['agents']['remove']) == 0
        && count($respuesta['log']) == 0;
}

// Restar del contador Placing/Dialing/Ringing/OnQueue según corresponda
function restarContadorLlamada($old_status, &$estadoCliente, &$respuesta)
{
    $k = strtolower($old_status);
    if ($k == 'dialing') $k = 'placing';
    if (isset($estadoCliente['statuscount'][$k]) && $estadoCliente['statuscount'][$k] > 0) {
        $estadoCliente['statuscount'][$k]--;
        $respuesta['statuscount']['update'][$k] = $estadoCliente['statuscount'][$k];
    }
}

// Agregar al contador correspondiente de progreso
function agregarContadorLlamada($new_status, &$estadoCliente, &$respuesta)
{
    $k = strtolower($new_status);
    if ($k == 'dialing') $k = 'placing';
    if (isset($estadoCliente['statuscount'][$k])) {
        $estadoCliente['statuscount'][$k]++;
        $respuesta['statuscount']['update'][$k] = $estadoCliente['statuscount'][$k];
    }
}

function formatoLlamadaNoConectada($activecall)
{
    $sFechaHoy = date('Y-m-d');
    $sDesde = (!is_null($activecall['queuestart']))
        ? $activecall['queuestart'] : $activecall['dialstart'];
    if (strpos($sDesde, $sFechaHoy) === 0)
        $sDesde = substr($sDesde, strlen($sFechaHoy) + 1);
    $sEstado = ($activecall['callstatus'] == 'placing' && !is_null($activecall['trunk']))
        ? _tr('dialing') : _tr($activecall['callstatus']);
    return array(
        'callid'        =>  $activecall['callid'],
        'callnumber'    =>  $activecall['callnumber'],
        'trunk'         =>  $activecall['trunk'],
        'callstatus'    =>  $sEstado,
        'desde'         =>  $sDesde,
    );
}

function formatoAgente($agent)
{
    $sEtiquetaStatus = _tr($agent['status']);
    $sFechaHoy = date('Y-m-d');
    $sDesde = '-';
    switch ($agent['status']) {
    case 'paused':
        // Prioridad de pausa: hold, break, agendada
        if ($agent['onhold']) {
            $sEtiquetaStatus = _tr('Hold');
            // TODO: desde cuándo está en hold?
        } elseif (!is_null($agent['pauseinfo'])) {
            $sDesde = $agent['pauseinfo']['pausestart'];
            $sEtiquetaStatus .= ': '.$agent['pauseinfo']['pausename'];
        }
        // TODO: exponer pausa de agendamiento
        break;
    case 'oncall':
        $sDesde = $agent['callinfo']['linkstart'];
        break;
    }
    if (strpos($sDesde, $sFechaHoy) === 0)
        $sDesde = substr($sDesde, strlen($sFechaHoy) + 1);
    return array(
        'agent'         =>  $agent['agentchannel'],
        'status'        =>  $sEtiquetaStatus,
        'callnumber'    =>  is_null($agent['callinfo']['callnumber']) ? '-' : $agent['callinfo']['callnumber'],
        'trunk'         =>  is_null($agent['callinfo']['trunk']) ? '-' : $agent['callinfo']['trunk'],
        'desde'         =>  $sDesde,
    );
}

function formatoLogCampania($entradaLog)
{
    $listaMsg = array(
        'Placing'   =>  _tr('LOG_FMT_PLACING'),
        'Dialing'   =>  _tr('LOG_FMT_DIALING'),
        'Ringing'   =>  _tr('LOG_FMT_RINGING'),
        'OnQueue'   =>  _tr('LOG_FMT_ONQUEUE'),
        'Success'   =>  _tr('LOG_FMT_SUCCESS'),
        'Hangup'    =>  _tr('LOG_FMT_HANGUP'),
        'OnHold'    =>  _tr('LOG_FMT_ONHOLD'),
        'OffHold'   =>  _tr('LOG_FMT_OFFHOLD'),
        'Failure'   =>  _tr('LOG_FMT_FAILURE'),
        'Abandoned' =>  _tr('LOG_FMT_ABANDONED'),
        'ShortCall' =>  _tr('LOG_FMT_SHORTCALL'),
        'NoAnswer'  =>  _tr('LOG_FMT_NOANSWER'),
    );
    $sMensaje = $listaMsg[$entradaLog['new_status']];
    foreach ($entradaLog as $k => $v) {
        if ($k == 'duration') $v = sprintf('%02d:%02d:%02d',
                ($v - ($v % 3600)) / 3600,
                (($v - ($v % 60)) / 60) % 60,
                $v % 60);
        $sMensaje = str_replace('{'.$k.'}', $v, $sMensaje);
    }

    return array(
        'id'        =>  $entradaLog['id'],
        'timestamp' =>  $entradaLog['datetime_entry'],
        'mensaje'   =>  $sMensaje,
    );
}

function modificarReferenciasLibreriasJS($smarty)
{
    $listaLibsJS_framework = explode("\n", $smarty->get_template_vars('HEADER_LIBS_JQUERY'));
    $listaLibsJS_modulo = explode("\n", $smarty->get_template_vars('HEADER_MODULES'));

    /* Las referencias a Ember.js y Handlebars se reordenan para que Handlebars
     * aparezca antes que Ember.js.
     */
    $sEmberRef = $sHandleBarsRef = NULL;
    foreach (array_keys($listaLibsJS_modulo) as $k) {
    	if (strpos($listaLibsJS_modulo[$k], 'themes/default/js/handlebars-') !== FALSE) {
            $sHandleBarsRef = $listaLibsJS_modulo[$k];
            unset($listaLibsJS_modulo[$k]);
        } elseif (strpos($listaLibsJS_modulo[$k], 'themes/default/js/ember-') !== FALSE) {
            $sEmberRef = $listaLibsJS_modulo[$k];
            unset($listaLibsJS_modulo[$k]);
        }
    }
    array_unshift($listaLibsJS_modulo, $sEmberRef);
    array_unshift($listaLibsJS_modulo, $sHandleBarsRef);
    $smarty->assign('HEADER_MODULES', implode("\n", $listaLibsJS_modulo));
    $smarty->assign('HEADER_LIBS_JQUERY', implode("\n", $listaLibsJS_framework));
}

function jsonflush($bSSE, $respuesta)
{
    $json = new Services_JSON();
    $r = $json->encode($respuesta);
    if ($bSSE)
        printflush("data: $r\n\n");
    else printflush($r);
}

function printflush($s)
{
    print $s;
    ob_flush();
    flush();
}

function generarEstadoHash($module_name, $estadoCliente)
{
    $estadoHash = md5(serialize($estadoCliente));
    $_SESSION[$module_name]['estadoCliente'] = $estadoCliente;
    $_SESSION[$module_name]['estadoClienteHash'] = $estadoHash;

    return $estadoHash;
}

function construirRespuesta_agentlinked($smarty, $sDirLocalPlantillas, $oPaloConsola, $callinfo, $infoLlamada, &$infoCampania) {
    
    foreach (array('calltype', 'campaign_id', 'callid', 'callnumber', 'uuid',
 'agent_number', 'remote_channel') as $k) {
        if (!isset($infoLlamada[$k]) && isset($callinfo[$k]))
            $infoLlamada[$k] = $callinfo[$k];
    }
    if ($callinfo['calltype'] == 'incoming' && is_null($callinfo['campaign_id'])) {
        $infoCampania['queue'] = $infoLlamada['queue'];
        $infoCampania['script'] = $oPaloConsola->leerScriptCola($infoCampania['queue']);
        $infoCampania['forms'] = NULL;
    }
    if (is_null($infoCampania['script']) || $infoCampania['script'] == '')
        $infoCampania['script'] = _tr('(No script available)');

    // Variables de canal de la llamada activa
    $chanvars = $oPaloConsola->leerVariablesCanalLlamadaActiva();

    // Fecha completa de la llamada
    $iDuracionLlamada = time() - strtotime($callinfo['linkstart']);

    // La consola empezó a atender a una llamada
    $registroCambio = array(
        'event' => 'agentlinked',
        'calltype' => $callinfo['calltype'],
        'campaign_id' => $callinfo['campaign_id'],
        'callid' => $callinfo['callid'],
        'txt_contacto_telefono' => $callinfo['callnumber'],
        'cronometro' => sprintf('%02d:%02d:%02d', ($iDuracionLlamada - ($iDuracionLlamada % 3600)) / 3600, (($iDuracionLlamada - ($iDuracionLlamada % 60)) / 60) % 60, $iDuracionLlamada % 60),
        'llamada_informacion' => _manejarSesionActiva_HTML_generarInformacion($smarty, $sDirLocalPlantillas, $infoLlamada, $infoCampania),
        'llamada_formulario' => _manejarSesionActiva_HTML_generarFormulario($smarty, $sDirLocalPlantillas, $infoLlamada, $infoCampania),
        'llamada_script' => $infoCampania['script'],
        'urlopentype' => isset($infoCampania['urlopentype']) ? $infoCampania['urlopentype'] : NULL,
        'url' => NULL,
        'uuid'                  =>  $infoLlamada['uuid']
    );

    if (isset($infoCampania['urltemplate']) && !is_null($infoCampania['urltemplate'])) {
        $registroCambio['url'] = construirUrlExterno($infoCampania['urltemplate'], $infoLlamada, $chanvars);
    }

    // Asignaciones específicas para llamadas entrantes
    if ($callinfo['calltype'] == 'incoming') {
        $comboContactos = array();
        foreach ($infoLlamada['matching_contacts'] as $idContacto => $tuplaContacto) {
            $infoContactoViejo = array();
            $sDescripcionContacto = '';
            foreach ($tuplaContacto as $attrContacto) {
                $sDescripcionContacto .= $attrContacto['value'] . ' ';
                if (in_array($attrContacto['label'], array('first_name', 'last_name', 'cedula_ruc')))
                    $infoContactoViejo[$attrContacto['label']] = $attrContacto['value'];
            }
            if (count($infoContactoViejo) == 3) {
                $sDescripcionContacto = $infoContactoViejo['cedula_ruc'] .
                        ' - ' . $infoContactoViejo['first_name'] . ' ' . $infoContactoViejo['last_name'];
            } else {
                /* TODO: dar formato adecuado para cuando contactos de llamadas
                 * entrantes puedan tener atributos arbitrarios */
            }

            /* El htmlentities de clave y valor es necesario porque del lado
             * Javascript, se usa concatenación directa de cadenas, porque el
             * objeto option devuelto por createElement no muestra la etiqueta
             * en IE6. Si se descubre la manera de hacerlo, hay que deshacer
             * el htmlentities aquí. */
            $comboContactos[htmlentities($idContacto, ENT_COMPAT, 'UTF-8')] = htmlentities($sDescripcionContacto, ENT_COMPAT, 'UTF-8');
        }
        if (count($comboContactos) == 0) {
            $comboContactos['x'] = htmlentities(_tr('(no matching contacts)'), ENT_COMPAT, 'UTF-8');
        }

        $registroCambio['lista_contactos'] = $comboContactos;
        $registroCambio['puede_confirmar_contacto'] = (count($comboContactos) > 1);
    }

    // Asignaciones específicas para llamadas salientes
    if ($callinfo['calltype'] == 'outgoing') {

        /* TODO: el siguiente código asume que el atributo 1 es el nombre
         * del cliente. Esta suposición se hereda del callcenter anterior.
         * Se debe de idear un método para dar formato al nombre del cliente
         * a partir de cualquier combinación de columnas */
        $sNombreCliente = isset($infoLlamada['call_attributes'][1]) ? $infoLlamada['call_attributes'][1]['value'] : _tr('(unavailable)');

        $registroCambio['txt_contacto_nombres'] = $sNombreCliente;
    }

    return $registroCambio;
}

function _manejarSesionActiva_HTML_generarInformacion($smarty, $sDirLocalPlantillas, $infoLlamada, $infoCampania) {
    
    $atributos = array();
    foreach ($infoLlamada['call_attributes'] as $iOrden => $atributo) {
        if (preg_match('|^http(s)?://|', $atributo['value'])) {
            $atributo['value'] = '<a target="_blank" href="' . $atributo['value'] . '">' . $atributo['value'] . '</a>';
        } else {
            $atributo['value'] = htmlentities($atributo['value'], ENT_COMPAT, 'UTF-8');
        }
        $atributos[] = $atributo;
    }

    // Caso especial: verificación de etiquetas de contact llamada entrante
    if ($infoLlamada['calltype'] == 'incoming' && count($atributos) == 5) {
        $n = 5;
        foreach ($atributos as $atributo) {
            if (in_array($atributo['label'], array('first_name', 'last_name', 'phone', 'cedula_ruc', 'contact_source')))
                $n--;
        }
        if ($n == 0) {
            $traduccion = array(
                'first_name' => _tr('First name'),
                'last_name' => _tr('Last name'),
                'phone' => _tr('Phone number'),
                'cedula_ruc' => _tr('National ID'),
            );

            // Se deben copiar los atributos, excepto el contact_source
            $t = array();
            foreach ($atributos as $atributo) {
                if ($atributo['label'] != 'contact_source') {
                    $atributo['label'] = $traduccion[$atributo['label']];
                    $t[] = $atributo;
                }
            }
            $atributos = $t;
        }
    }

    // Asignaciones independientes del tipo de llamada
    $smarty->assign(array(
        'LBL_NOMBRE_CAMPANIA' => _tr('Campaign'),
        'LBL_CALL_ID' => _tr('Internal Call ID'),
        'TEXTO_NOMBRE_CAMPANIA' => (isset($infoCampania['name']) ? $infoCampania['name'] : '(none)'),
        'TEXTO_CALL_ID' => $infoLlamada['calltype'] . '-' .
        (isset($infoLlamada['campaign_id']) ? $infoLlamada['campaign_id'] : 'q' . $infoLlamada['queue']) . '-' .
        (isset($infoLlamada['contact_id']) ? 'c' . $infoLlamada['contact_id'] : (isset($infoLlamada['callid']) ? $infoLlamada['callid'] : $infoLlamada['call_id'])),
        'CALLINFO_CALLTYPE' => $infoLlamada['calltype'],
        'LBL_CONTACTO_TELEFONO' => _tr('Phone number'),
        'TEXTO_CONTACTO_TELEFONO' => $infoLlamada['phone'],
    ));

    // Asignaciones específicas para llamadas entrantes
    if ($infoLlamada['calltype'] == 'incoming') {
        $comboContactos = array();
        foreach ($infoLlamada['matching_contacts'] as $idContacto => $tuplaContacto) {
            $infoContactoViejo = array();
            $sDescripcionContacto = '';
            foreach ($tuplaContacto as $attrContacto) {
                $sDescripcionContacto .= $attrContacto['value'] . ' ';
                if (in_array($attrContacto['label'], array('first_name', 'last_name', 'cedula_ruc')))
                    $infoContactoViejo[$attrContacto['label']] = $attrContacto['value'];
            }
            if (count($infoContactoViejo) == 3) {
                $comboContactos[$idContacto] = $infoContactoViejo['cedula_ruc'] .
                        ' - ' . $infoContactoViejo['first_name'] . ' ' . $infoContactoViejo['last_name'];
            } else {
                /* TODO: dar formato adecuado para cuando contactos de llamadas
                 * entrantes puedan tener atributos arbitrarios */
                $comboContactos[$idContacto] = $sDescripcionContacto;
            }
        }
        if (count($comboContactos) == 0) {
            $comboContactos[''] = _tr('(no matching contacts)');
        }
        $smarty->assign(array(
            'LBL_CONTACTO_SELECT' => _tr('Contact'),
            'LISTA_CONTACTOS' => $comboContactos,
            'BTN_CONFIRMAR_CONTACTO' => _tr('Confirm contact'),
        ));
    }

    // Asignaciones específicas para llamadas salientes
    if ($infoLlamada['calltype'] == 'outgoing') {

        /* TODO: el siguiente código asume que el atributo 1 es el nombre
         * del cliente. Esta suposición se hereda del callcenter anterior.
         * Se debe de idear un método para dar formato al nombre del cliente
         * a partir de cualquier combinación de columnas */
        $sNombreCliente = isset($infoLlamada['call_attributes'][1]) ? $infoLlamada['call_attributes'][1]['value'] : _tr('(unavailable)');

        $smarty->assign(array(
            'LBL_CONTACTO_NOMBRES' => _tr('Names'),
            'TEXTO_CONTACTO_NOMBRES' => $sNombreCliente,
        ));
    }

    $smarty->assign(array(
        'MSG_NO_ATTRIBUTES' => _tr('No information available for this call'),
        'ATRIBUTOS_LLAMADA' => $atributos,
    ));
    return $smarty->fetch("$sDirLocalPlantillas/agent_console_atributos.tpl");
}
