#!/bin/bash

PATH_DB=/var/www/db
PATH_PATCH=$(pwd)
PATH_MODULES=/var/www/html/modules


id=$(sqlite3 "$PATH_DB/acl.db" "SELECT id FROM acl_resource WHERE name='contact_file' LIMIT 1")

if [ "$id" ]
then

    sqlite3 "$PATH_DB/acl.db" "DELETE FROM acl_module_privileges WHERE id_resource = $id"

    sqlite3 "$PATH_DB/acl.db" "INSERT INTO acl_module_privileges (id_resource, privilege, desc_privilege) VALUES ($id, 'delete', 'Delete Contact File')"
    sqlite3 "$PATH_DB/acl.db" "INSERT INTO acl_module_privileges (id_resource, privilege, desc_privilege) VALUES ($id, 'upload', 'Upload Contact File')"
    sqlite3 "$PATH_DB/acl.db" "INSERT INTO acl_module_privileges (id_resource, privilege, desc_privilege) VALUES ($id, 'download', 'Download Contact File')"

    echo "banco de dados atualizado."

    mv $PATH_MODULES/contact_file /tmp/contact_file-$(date +%s)
    tar -zxf $PATH_PATCH/modules/contact_file.tar.gz -C $PATH_MODULES

    echo "arquivos atualizados."
   
else
    echo "Erro ao atualizar ..."
fi