<?php

include_once("libs/paloSantoDB.class.php");


class FileList {
    
    var $_DB;
    var $errMsg;

    public function __construct(&$pDB) {
   
        if (is_object($pDB)) {
            $this->_DB = & $pDB;
            $this->errMsg = $this->_DB->errMsg;
        } else {
            $dsn = (string) $pDB;
            $this->_DB = new paloDB($dsn);

            if (!$this->_DB->connStatus) {
                $this->errMsg = $this->_DB->errMsg;
            } else {
                // debo llenar alguna variable de error
            }
        }
    }
    
    public function get_files() {
        
        $SQL = <<<SQL_SELECT_CONTACTFILES
SELECT * FROM contact_list ORDER BY create_at DESC
SQL_SELECT_CONTACTFILES;
        
        $paramWhere = array();
        $paramSQL = array();
        
        if (count($paramWhere) > 0) $SQL .= ' WHERE '.implode(' AND ', $paramWhere);
        
        $arr_result = $this->_DB->fetchTable($SQL, TRUE, $paramSQL);
        if (!is_array($arr_result)) {
            $this->errMsg = $this->_DB->errMsg;
            return FALSE;
        }
        return $arr_result;
    }
    
    public function delete_file($id) {

        $SQL = <<<SQL_SELECT_CONTACTFILE
SELECT name_storage, extension FROM contact_list WHERE id = ? LIMIT 1
SQL_SELECT_CONTACTFILE;

        $arr_result = $this->_DB->fetchTable($SQL, TRUE, array($id));

        if (count($arr_result) > 0) {

            if (!$this->_DB->genQuery('DELETE FROM contact_list WHERE id = ?', array($id))) {
                $this->errMsg = $this->_DB->errMsg;
                return FALSE;
            } else
                return $arr_result[0]['name_storage'] . '.' . $arr_result[0]['extension'];
        } else
            return FALSE;
    }

    public function insert_file($data = array()) {
        
        if (count($data) > 0) {
            
            
        $SQL = <<<SQL_INSERT_FILE
INSERT INTO contact_list (name, type_phone, order_by, add_zero, name_storage, num_contact, size, extension)
VALUES (?, ?, ?, ?, ?, ?, ?, ?)
SQL_INSERT_FILE;
        
        if (!$this->_DB->genQuery($SQL, array($data[0], $data[1], $data[2], $data[3], $data[4], $data[5], $data[6], $data[7])))
            $this->errMsg = $this->_DB->errMsg;
        }
    }
    
    
    public function get_file($id) {
        
           $SQL = <<<SQL_SELECT_CONTACTFILES
SELECT * FROM contact_list 
SQL_SELECT_CONTACTFILES;
        
        $paramWhere = array('id = ?');
        
        $paramSQL = array($id);
        
        if (count($paramWhere) > 0) $SQL .= ' WHERE '.implode(' AND ', $paramWhere); //echo $SQL; exit;
        
        $arr_result = $this->_DB->fetchTable($SQL, TRUE, $paramSQL);
        if (!is_array($arr_result)) {
            $this->errMsg = $this->_DB->errMsg;
            return FALSE;
        }
        return $arr_result;
        
    }

}
