<?php

require_once "libs/paloSantoForm.class.php";
require_once "libs/FileList.class.php";
include_once "libs/paloSantoGrid.class.php";
require_once "libs/misc.lib.php";
require_once "libs/paloSantoACL.class.php";

function _moduleContent(&$smarty, $module_name) {
    
    //include module files
    include_once "modules/$module_name/configs/default.conf.php";
    include_once "modules/$module_name/libs/Uuid.class.php";

    load_language_module($module_name);
    //global variables
    global $arrConf;
    global $arrConfModule;
    $arrConf = array_merge($arrConf, $arrConfModule);

    //folder path for custom templates
    $base_dir = dirname($_SERVER['SCRIPT_FILENAME']);
    $templates_dir = (isset($arrConf['templates_dir'])) ? $arrConf['templates_dir'] : 'themes';
    $local_templates_dir = "$base_dir/modules/$module_name/" . $templates_dir . '/' . $arrConf['theme'];

    $user = isset($_SESSION['issabel_user'])?$_SESSION['issabel_user']:"";

    $pDB = new paloDB($arrConf['cadena_dsn_storage']);
    
    $action = getParameter('action');

    switch ($action) {

        case "organizer":
            if (hasModulePrivilege($user, $module_name, 'upload'))
                $content = Organizer($pDB, $smarty, $module_name, $local_templates_dir, $pDB, $arrConf); // detection button
            else 
                $content = "";
            break;

        case "upload":
            if (hasModulePrivilege($user, $module_name, 'upload'))
                $content = viewFormFile($smarty, $module_name, $local_templates_dir);
            else 
                $content = "";
            break;

        default:
            $content = listFile($pDB, $smarty, $module_name, $local_templates_dir, $user);
            break;
    } 
    return $content;
}


function listFile($pDB, $smarty, $module_name, $local_templates_dir, $user) {
    
    global $arrLang;
    global $arrConfModule;
    $arrData = '';
    $oFileList = new FileList($pDB);

    $id_file = NULL;
    if (isset($_POST['id_file']) && ctype_digit($_POST['id_file']))
        $id_file= $_POST['id_file'];
   
    if (isset($_POST['delete']) && !is_null($id_file) && hasModulePrivilege($user, $module_name, 'delete')) {
        if ($nameFile = $oFileList->delete_file($id_file)) {
            
            unlink($arrConfModule['path_storage'] . $nameFile);
            
           // $smarty->assign("mb_title", _tr('Message'));
            //$smarty->assign("mb_message", _tr('File was deleted successfully'));
            Header("Location: ?menu=$module_name");
            
        } else {
            $msg_error = ($oFileList->errMsg != "") ? "<br/>" . $oFileList->errMsg : "";
            $smarty->assign("mb_title", _tr('Delete Error'));
            $smarty->assign("mb_message", _tr('Error when deleting the File') . $msg_error);
        }
    }
    
     if (isset($_POST['download']) && !is_null($id_file)) {
         
         downloadFile($id_file, $pDB, $smarty, $module_name, $local_templates_dir, $user);
         //Header("Location: ?menu=$module_name");
     }
    
    $arrFiles = $oFileList->get_files();
    
    $oGrid = new paloSantoGrid($smarty);
    $oGrid->setLimit(50);
    $oGrid->setTotal(count($arrFiles));
    $offset = $oGrid->calculateOffset();
    
    $arrCampaign = array_slice($arrFiles, $offset, $oGrid->getLimit());

    if (is_array($arrFiles)) {
        foreach ($arrFiles as $file) {
            $arrData[] = array(
                "<input class=\"button\" type=\"radio\" name=\"id_file\" value=\"$file[id]\" />",
                $file['name'],
                $file['type_phone'] == 'all'? 'Fixo e Móvel': ($file['type_phone'] == 'fix'?'Fixo': 'Móvel'),
                $file['order_by'] == 'line'?'Linhas':'Colunas',
                $file['add_zero'] == 0?'Não':'Sim',
                $file['num_contact'],
                formatBytes($file['size']),
                $file['create_at']
                    
            );
        }
    }
    $oGrid->setWidth("99%");
    $oGrid->setIcon("images/list.png");
    //$oGrid->setURL($url);
    $oGrid->setColumns(
            array(
                '',
                _tr('Name'), 
                _tr('Type of Phones'),
                _tr('Order by'),
                _tr('Add Zero'),
                _tr('Numbers of Phones'),
                _tr('Size'),  
                _tr('Create at')
                )
            );
    

    if (hasModulePrivilege($user, $module_name, 'upload'))        
        $oGrid->customAction("?menu=$module_name&action=new_campaign&action=upload", _tr('Upload Arquivo'), 'upload', TRUE);
      
    if (hasModulePrivilege($user, $module_name, 'download'))
        $oGrid->customAction("download",_tr('Download'),"download",FALSE);
    
    if (hasModulePrivilege($user, $module_name, 'delete'))
        $oGrid->deleteList(_tr('Are you sure you wish to delete file?'), 'delete', _tr('Delete'));

    $oGrid->setData($arrData);
    return $oGrid->fetchGrid();
}


function viewFormFile($smarty, $module_name, $local_templates_dir) {

    $arrForm =  createFieldForm(); 
    
    $oForm = new paloForm($smarty, $arrForm);
        
    $smarty->assign("MODULE_NAME",$module_name);
    $smarty->assign("CALL_FILE",_tr('Call File'));
    
    return $oForm->fetchForm($local_templates_dir."/formFile.tpl");
}

function createFieldForm() {
    
    return array(
        'phone_type' => array(
            "LABEL" => _tr("Phone Type"),
            "REQUIRED" => "no",
            "INPUT_TYPE" => "SELECT",
            "INPUT_EXTRA_PARAM" => array(0 => 'Fixo e Móvel', 1 => 'Fixo', 2 => 'Móvel'),
            "VALIDATION_TYPE" => "text",
            "VALIDATION_EXTRA_PARAM" => ""
        ),
         'order_by' => array(
            "LABEL" => _tr("Order By"),
            "REQUIRED" => "no",
            "INPUT_TYPE" => "SELECT",
            "INPUT_EXTRA_PARAM" => array(1 => 'Colunas', 0 => 'Linhas'),
            "VALIDATION_TYPE" => "text",
            "VALIDATION_EXTRA_PARAM" => ""
        ),
          'add_zero' => array(
            "LABEL" => _tr("Add Zero"),
            "REQUIRED" => "no",
            "INPUT_TYPE" => "SELECT",
            "INPUT_EXTRA_PARAM" => array(1 => 'Sim', 0 => 'Não'),
            "VALIDATION_TYPE" => "text",
            "VALIDATION_EXTRA_PARAM" => ""
        ),
    );
}

function Organizer($pDB, $smarty, $module_name, $local_templates_dir) {

    if ($_FILES['fixcsv']['name'] == '' || $_POST['cancel'])
       return  listFile($pDB, $smarty, $module_name, $local_templates_dir);
        
    $fileext = strtolower(end(explode('.', $_FILES['fixcsv']['name'])));
    $filename = explode('.', $_FILES['fixcsv']['name'])[0];

 
    if ($fileext != 'csv')
        exit;
    
    global $arrConfModule;


    if ($handle = fopen($_FILES['fixcsv']['tmp_name'], "r")) {

        if (!($_FILES['fixcsv']['size'] <= 10000000)) {
            echo "O tamanho do arquivo é maior que 10MB.";
            exit;
        }
        
        switch ($_POST['phone_type']){
            case 0:
                $phone_type = 'all';
                break;
            case 1:
                $phone_type = 'fix';
                break;
            case 2:
                $phone_type = 'movel';
                break;
            default:
                $phone_type = 'all';
        }
        
        switch ($_POST['order_by']){
            case 0:
                $order_by = 'line';
                break;
            case 1:
                $order_by = 'column';
                break;
            default:
                $order_by = 'line';
        }
        
         switch ($_POST['add_zero']){
            case 0:
                $add_zero = false;
                break;
            case 1:
                $add_zero = true;
                break;
            default:
                $add_zero = false;
        }

        $line_header = fgetcsv($handle, 4096, ';');

        // Mapear colunas
        $header_required = array();
        $header_optional = array();

        $fones = array();
        $cpfs = array();

        foreach ($line_header as $key => $value) {
            $header_original[] = $value;

            if (substr_count(strtoupper($value), 'NOME') || substr_count(strtoupper($value), 'CLIENT')) {
                $header_optional['NOME'] = $key;
                continue;
            }

            if (substr_count(strtoupper($value), 'CPF')) {
                $header_optional ['CPF'] = $key;
                continue;
            }

            if (substr_count(strtoupper($value), 'DDD')) {
                $header_required ['DDD'][] = $key;
                continue;
            }

            if (substr_count(strtoupper($value), 'FONE') || substr_count(strtoupper($value), 'TEL') || substr_count(strtoupper($value), 'CEL') || substr_count(strtoupper($value), 'MOVEL')) {
                $header_required ['FONE'][] = $key;
                continue;
            }

            if (substr_count(strtoupper($value), 'NB') || substr_count(strtoupper($value), 'BENEF') || substr_count(strtoupper($value), 'INSS')) {
                $header_optional ['NB'] = $key;
                continue;
            }

            if (substr_count(strtoupper($value), 'NASC')) {
                $header_optional ['NASC'] = $key;
                continue;
            }

            // Descarta o field UUID caso tenha
            if (substr_count(strtoupper($value), 'UUID')) {
                continue;
            }
            
            if (substr_count(strtoupper($value), 'DNC')) {
                continue;
            }
            
            
            $header_optional[strtoupper($value)] = $key;
        }


        if ( !isset($header_required['FONE']))
            return false;

        $header_out = array_merge($header_required, $header_optional);
        unset($header_out['FONE']);
        unset($header_out['DDD']);
        
        $output_file= 'UUID,DNC,FONE,' . implode(',', array_keys($header_optional)) . "\r\n";

        $ddd = false;
        if (count($header_required['DDD']) > 0)
            $ddd = true;

        $Uuid = new Uuid();
        $count = 0;
        
        while (($line = fgetcsv($handle, 4096, ';')) !== FALSE) {

            $uuid_line = $Uuid->v4();
            $dnc = 0;
            if ($ddd) {

                foreach ($header_required['DDD'] as $ddd_key => $ddd_value) {

                    $arr_data = array();
                    if (!empty($line[$ddd_value]) && !empty($line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]])) {

                        $fone = $line[$ddd_value] . $line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]];
                        
                        if ($fone[0] !== '0')
                            $fone = '0' . $line[$ddd_value] . $line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]];
                        
			    $fone = preg_replace('/[^0-9]/', '', (string) $fone);

			if (strlen($fone) < 10) continue;

                         // Filter phone type
                        if ($phone_type == 'fix') {
                            if (!validar_tel($fone)) continue;  
                        }
                        else if ($phone_type == 'movel')
                            if (!validar_cel($fone)) continue;
                        
                        // Add or slice zero    
                        if ($fone[0] !== '0') {
                            if ($add_zero)
                                $fone = '0' . $fone;
                        } else {
                            if (!$add_zero)
                                $fone = preg_replace('/^0+/', '', (string) $fone);
                        }
                        
                        if (!$fones[$fone] || (!validar_tel($fone) && !validar_cel($fone))) {
                            $arr_data [] = $uuid_line;
                            $arr_data [] = $dnc;
                            $dnc++;
                            $arr_data[] = $fone;
                            $count++;

                            foreach ($header_optional as $optk => $optv)
                                $arr_data[] = out_replace($line[$header_optional[$optk]], $line, $header_out);

                            // Order by line or column
                            if ($order_by == 'line')
                                $output .= implode(',', $arr_data) . "\r\n";
                            else if ($order_by == 'column')
                                $output[$fonek] .= implode(',', $arr_data) . "\r\n";

                            $fones[$fone] = 1;
                        }
                    }
                }
            } else {
               // $dnc = false;
                foreach ($header_required['FONE'] as $fonek => $fonev) {
                    $arr_data = array();
                    if (!empty($line[$fonev])) {

                        $fone = $line[$fonev];
                        
                        $fone = preg_replace('/[^0-9]/', '', (string) $fone);
	
			            if (strlen($fone) < 10) continue;
                        
                        // Filter phone type
                        if ($phone_type == 'fix') {
                            if (!validar_tel($fone)) continue;  
                        }
                        else if ($phone_type == 'movel')
                            if (!validar_cel($fone)) continue;
                        
                        // Add or slice zero    
                        if ($fone[0] !== '0') {
                            if ($add_zero)
                                $fone = '0' . $fone;
                        } else {
                            if (!$add_zero)
                                $fone = preg_replace('/^0+/', '', (string) $fone);
                        }

                        if (!$fones[$fone] || (!validar_tel($fone) && !validar_cel($fone))) { 
                            $arr_data [] = $uuid_line;
                            $arr_data [] = $dnc; 
                            $dnc++;
                            $arr_data[] = $fone; 
                            $count++;

                            foreach ($header_optional as $optk => $optv)
                                $arr_data[] = out_replace($line[$header_optional[$optk]], $line, $header_out);

                            // Order by line or column
                            if ($order_by == 'line')
                                $output .= implode(',', $arr_data) . "\r\n";
                            else if ($order_by == 'column')
                                $output[$fonek] .= implode(',', $arr_data) . "\r\n";

                            $fones[$fone] = 1;
                        }
                    } 
                }
            }
            
        }
    }
    
    fclose($handle);   
    
    //$name_out = dirname(__FILE__) . '/upload_csv/' . time() . "_out.csv";
    
    $uuid = $Uuid->v4();
    
    $name_storage =  $uuid . '-' . time() . '.csv';
    
    $name_out = $arrConfModule['path_storage'] . $name_storage; 
    
    $handle_out = fopen($name_out, "wb");

    if (!is_array($output)) $output_file .= $output;
    
    else        
        foreach ($output as $column)
            $output_file .= $column;
              
    fwrite($handle_out, $output_file);

    if (fclose($handle_out)) {
        
        $arrData = array(
            basename($_FILES['fixcsv']['name'], '.csv'),
            
            $phone_type,
            $order_by,
            ($add_zero? 1:0),
            
            basename($name_storage, '.csv'),
            $count,
            filesize($name_out),
            'csv'
            
        );
        
        $oFileList = new FileList($pDB);
        
        $oFileList->insert_file($arrData);
        
        Header("Location: ?menu=$module_name");
        exit;
    }
    
}

function downloadFile($file_id, $pDB, $smarty, $module_name, $local_templates_dir, $user) {
    
    if (!hasModulePrivilege($user, $module_name, 'download'))      
        return false;
            
    global $arrConfModule;

    ini_set('max_execution_time', 3600);

    $oFileList = new FileList($pDB);

    $arrFile =  $oFileList->get_file($file_id);

    if (!is_array($arrFile) || count($arrFile) == 0) {
        $smarty->assign("mb_title", 'Unable to read file');
        print 'Cannot read file - ' . $oFileList->errMsg;
        return '';
    } else {
         $path = $arrConfModule['path_storage'] . $arrFile[0]['name_storage'] . '.csv';

        header('Content-Description: File Transfer');
        header('Content-Disposition: attachment; filename="' . $arrFile[0]['name'] .'-GrupoVoip'. '.csv"');
        header('Content-Type: application/octet-stream');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($path));
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Expires: 0');

        readfile($path);
    }
            
}

//============================= Helpers ========================================
    

function formatBytes($bytes, $precision = 2) {
    $unit = [" B", " KB", " MB", " GB"];
    $exp = floor(log($bytes, 1024)) | 0;
    return round($bytes / (pow(1024, $exp)), $precision).$unit[$exp];
}


function out_replace($str, $values, $position) {

    $pattern = array();
    $replacement = array();

    foreach ($position as $key => $val) {
        $pattern[] = "/{{" . $key . "}}/i";
        $replacement[] = $values[$position[$key]];
    }


    return preg_replace($pattern, $replacement, $str);
}

function validar_cpf($cpf) {
    
    if (empty($cpf))
        return false;
    
    while(strlen($cpf) < 11){
        $cpf = '0' . $cpf;
    }
    
    $invalidos = array(
        '00000000000',
        '11111111111',
        '22222222222',
        '33333333333',
        '44444444444',
        '55555555555',
        '66666666666',
        '77777777777',
        '88888888888',
        '99999999999'
    );
    
    if (in_array($cpf, $invalidos))
        return false;
    
    $cpf = preg_replace('/[^0-9]/', '', (string) $cpf);
    // Valida tamanho
    if (strlen($cpf) != 11)
        return false;
    // Calcula e confere primeiro dígito verificador
    for ($i = 0, $j = 10, $soma = 0; $i < 9; $i++, $j--)
        $soma += $cpf{$i} * $j;
    $resto = $soma % 11;
    if ($cpf{9} != ($resto < 2 ? 0 : 11 - $resto))
        return false;
    // Calcula e confere segundo dígito verificador
    for ($i = 0, $j = 11, $soma = 0; $i < 10; $i++, $j--)
        $soma += $cpf{$i} * $j;
    $resto = $soma % 11;
    return $cpf{10} == ($resto < 2 ? 0 : 11 - $resto);
}

function validar_cel($cel) {
    
     $cel = preg_replace('/^0+/', '', (string) $cel);
    
    if(preg_match("/^[1-9][1-9][2-9]\d{8}$/", $cel)) 
        return true;
    else false;
}

function validar_tel($tel) { 

     $tel = preg_replace('/^0+/', '', (string) $tel);
    
    if(preg_match("/^[1-9][1-9][1-5]\d{7}$/", $tel)) 
        return true;
    else 
        return false;
}

function hasModulePrivilege($user, $module, $privilege) {

    global $arrConf;

    $pDB = new paloDB($arrConf['issabel_dsn']['acl']);
    $pACL = new paloACL($pDB);

    if (method_exists($pACL, 'hasModulePrivilege'))
        return $pACL->hasModulePrivilege($user, $module, $privilege);

    $isAdmin = ($pACL->isUserAdministratorGroup($user) !== FALSE);
    return ($isAdmin && in_array($privilege, array(
                'download'
    )));
}
