#!/bin/bash

PATH_AGI=/var/lib/asterisk/agi-bin
PATH_BACKUP_ASTERISK=$PATH_BACKUP/asterisk

PATH_PATCH_ASTERISK=$PATH_PATCH/asterisk
PATH_PATCH_ASTERISK_AGI=$PATH_PATCH_ASTERISK/agi

_agi() {
    # create dir backup
    mkdir -p $PATH_BACKUP_ASTERISK/agi

    for path in "$PATH_PATCH_ASTERISK_AGI"/*
    do
        filename=$(basename "$path")
        if test -f "$PATH_AGI/$filename"; then
            # backup
            mv $PATH_AGI/$filename $PATH_BACKUP_ASTERISK/agi
        fi

        cp $path $PATH_AGI/$filename
        
    done

    # set permission
    chown -R asterisk:asterisk $PATH_AGI
    
    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} agis foram atualizados."
}

_asterisk() {
    _agi
}