<?php 

include_once "libs/paloSantoGrid.class.php";
include_once "libs/paloSantoForm.class.php";

function _moduleContent(&$smarty, $module_name)
{
    //include module files
    include_once "modules/$module_name/configs/default.conf.php";
    include_once "modules/$module_name/libs/paloSantoReportFlat.class.php";

    //include file language agree to issabel configuration
    //if file language not exists, then include language by default (en)
    $lang=get_language();
    $base_dir=dirname($_SERVER['SCRIPT_FILENAME']);
    $lang_file="modules/$module_name/lang/$lang.lang";
    if (file_exists("$base_dir/$lang_file")) include_once "$lang_file";
    else include_once "modules/$module_name/lang/en.lang";

    //global variables
    global $arrConf;
    global $arrConfModule;
    global $arrLang;
    global $arrLangModule;
    $arrConf = array_merge($arrConf,$arrConfModule);
    $arrLang = array_merge($arrLang,$arrLangModule);

    //folder path for custom templates
    $templates_dir=(isset($arrConf['templates_dir']))?$arrConf['templates_dir']:'themes';
    $local_templates_dir="$base_dir/modules/$module_name/".$templates_dir.'/'.$arrConf['theme'];

    //conexion resource
    $pDB = new paloDB($arrConf['dsn_conn_database']);
    //$pDB = "";
    // $dsn = generarDSNSistema("root","call_center");
    // $pDB = new paloDB($dsn);



    //actions 
    $action = getAction();
    $content = "";

    switch($action){
        default:
            $content = reportFlat($smarty, $module_name, $local_templates_dir, $pDB, $arrConf);
            break;
    }
    return $content;
}

function reportFlat($smarty, $module_name, $local_templates_dir, &$pDB, $arrConf)
{
    $pReport = new paloSantoReportFlat($pDB);
    $filter_field = getParameter("filter_field");
    $filter_value = getParameter("filter_value");

    //begin grid parameters
    $oGrid  = new paloSantoGrid($smarty);
    $oGrid->setTitle(_tr("Report Flat"));
    $oGrid->pagingShow(true); // show paging section.

//     $oGrid->enableExport();   // enable export.
//     $oGrid->setNameFile_Export(_tr("Pesquisa"));

$url = construirURL(
    array(
        'menu' => $module_name,
        "filter_field" =>  $filter_field,
        "filter_value" =>  $filter_value), 
    array('nav', 'start')
);
// exit;
    // $url = array(
    //     "menu"         =>  $module_name,
    //     "filter_field" =>  $filter_field,
    //     "filter_value" =>  $filter_value);


    if (count($_POST) == 0) {
        $_POST['filter_field'] = "";
    }

    $arrFilter = array(
        "campaign_name" => _tr("Campanha"),
        "start_time" => _tr("Data"),
        "number" => _tr("Telefone"),
        "nome" => _tr("Nome"),
        "cpf" => _tr("CPF"),
        "key_pressed" => _tr("Tecla"),
        "" => _tr("Sem Filtro"),
    );

    $oGrid->setTitle(_tr("Report Flat"));
    $oGrid->setWidth("99%");
    $oGrid->setURL($url);
    // $oGrid->addFilterControl( _tr("Filter applied ") . $arrFilter[$_POST['filter_field']] . ($_POST['filter_field'] ? " = Todos": ""), $_POST, array("filter_field" => ""), TRUE);

    $arrColumns = array(_tr("Campanha"),_tr("Data de Início"),_tr("Telefone"),_tr("Nome"),_tr("CPF"),_tr("Tecla"));
    $oGrid->setColumns($arrColumns);

    $total   = $pReport->getNumReport($filter_field, $filter_value);
    $arrData = null;
    if($oGrid->isExportAction()){
        $limit  = $total; // max number of rows.
        $offset = 0;      // since the start.
    }
    else{
        $limit  = 20;
        $oGrid->setLimit($limit);
        $oGrid->setTotal($total);
        $offset = $oGrid->calculateOffset();
    }

    $arrResult =$pReport->getReport($limit, $offset, $filter_field, $filter_value);

    if(is_array($arrResult) && $total>0){
        foreach($arrResult as $key => $value){
            $arrTmp[0] = $value['campaign_name'];
            // $arrTmp[1] = $value['start_time'];
            $arrTmp[1] = date('d-m-Y H:i:s',strtotime($value['start_time']));
            $arrTmp[2] = $value['number'];
            $arrTmp[3] = $value['name'];
                // $arrTmp[3] = date('d-m-Y',strtotime($value['data']));
            $arrTmp[4] = $value['cpf'];
            $arrTmp[5] = $value['key_pressed'];
            // $arrTmp[6] = $value['nome'];
            // $arrTmp[7] = $value['cpf'];
            // $arrTmp[8] = $value['contato'];
            // $arrTmp[9] = $value['controle'];
            $arrData[] = $arrTmp;
        }
    }
    $oGrid->setData($arrData);

    //begin section filter
   $oFilterForm = new paloForm($smarty, createFieldFilter());
    $smarty->assign("SHOW", _tr("Show"));
    $htmlFilter  = $oFilterForm->fetchForm("$local_templates_dir/filter.tpl","",$_POST);
    //end section filter

    $oGrid->showFilter(trim($htmlFilter));
    $content = $oGrid->fetchGrid();
    //end grid parameters

// $content = "teste";
    return $content;
}

function createFieldFilter(){
    $arrFilter = array(
            "campaign_name" => _tr("Campanha"),
            "start_time" => _tr("Data"),
            "number" => _tr("Telefone"),
            "nome" => _tr("Nome"),
            "cpf" => _tr("CPF"),
            "key_pressed" => _tr("Tecla"),
            // "nome" => _tr("Nome"),
            // "cpf" => _tr("CPF"),
            // "contato" => _tr("Contato"),
            // "controle" => _tr("Controle"),
                    );

    $arrFormElements = array(
            "filter_field" => array("LABEL"                  => _tr("Search"),
                                    "REQUIRED"               => "no",
                                    "INPUT_TYPE"             => "SELECT",
                                    "INPUT_EXTRA_PARAM"      => $arrFilter,
                                    "VALIDATION_TYPE"        => "text",
                                    "VALIDATION_EXTRA_PARAM" => ""),
            "filter_value" => array("LABEL"                  => "",
                                    "REQUIRED"               => "no",
                                    "INPUT_TYPE"             => "TEXT",
                                    "INPUT_EXTRA_PARAM"      => "",
                                    "VALIDATION_TYPE"        => "text",
                                    "VALIDATION_EXTRA_PARAM" => ""),
                    );
    return $arrFormElements;
}


function getAction()
{
    if(getParameter("save_new")) //Get parameter by POST (submit)
        return "save_new";
    else if(getParameter("save_edit"))
        return "save_edit";
    else if(getParameter("delete"))
        return "delete";
    else if(getParameter("new_open"))
        return "view_form";
    else if(getParameter("action")=="view")      //Get parameter by GET (command pattern, links)
        return "view_form";
    else if(getParameter("action")=="view_edit")
        return "view_form";
    else
        return "report"; //cancel
}

