<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class FinazModel extends CI_Model {
    
    public function get_recording($uniqueid) {
        
        $query = $this->db   
                ->select('recordingfile')
                ->from('asteriskcdrdb.cdr')
                ->where('uniqueid', $uniqueid)
                ->get();
        
        $recording = $query->result_array();
        
        if (count($recording) == 0)
            return false;
        else 
            return $recording[0]['recordingfile'];
        
    }
    
    public function mailing_process($mailing_name, $queue) {

        $data = array(
            'name' => $mailing_name,
	    'queue' => $queue	
        );

        $this->db->insert('mailing_process', $data);
        
        return $this->db->insert_id();
    }
    
    public function set_transfer($queue, $exten, $phone, $channel_transfer) {
        $data = array(
            'queue' => (int) $queue,
            'exten' => (int) $exten,
            'phone' => "$phone",
            'channel' => $channel_transfer
        );
        
        $this->db->insert('log_transfers', $data);
        
        return $this->db->insert_id();
    }
    
    public function mailing_delete($team_id) {
	date_default_timezone_set('America/Sao_Paulo');

        $id_campaign = $this->get_idcampaign($team_id);
        
        if ($id_campaign) {
            $this->db->trans_begin();

            $this->db->query("DELETE FROM call_center.campaign_form WHERE id_campaign = $id_campaign");
            $this->db->query("DELETE FROM call_center.call_recording WHERE id_call_outgoing IN (SELECT id from call_center.calls WHERE id_campaign = $id_campaign)");   
            $this->db->query("DELETE FROM call_center.call_attribute WHERE id_call IN (SELECT id from call_center.calls WHERE id_campaign = $id_campaign)");       
            $this->db->query("DELETE FROM call_center.form_data_recolected WHERE id_calls IN (SELECT id from call_center.calls WHERE id_campaign = $id_campaign)");        
            $this->db->query("DELETE call_center.call_progress_log FROM call_center.call_progress_log, call_center.calls WHERE call_progress_log.id_call_outgoing = calls.id AND calls.id_campaign = $id_campaign");     
           // $this->db->query("DELETE FROM call_center.calls WHERE id_campaign = $id_campaign AND uniqueid IS NULL");
            $this->db->query("DELETE FROM call_center.calls WHERE id_campaign = $id_campaign");
            $this->db->query("DELETE FROM call_center.campaign WHERE id = $id_campaign");

	    $this->db->query("UPDATE mailing_process SET deleted = 1 WHERE id_campaign = $id_campaign");

	    $this->db->query("UPDATE mailing_process SET deleted_at = '"  . date('Y-m-d H:i:s') . "' WHERE id_campaign = $id_campaign");

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return false;
            } else {
                $this->db->trans_commit();
                return true;
            }
        } else
            return false;
    }
    
    public function get_idcampaign($team_id) {

        $this->db->select('id_campaign');
        $this->db->from('mailing_process');
        $this->db->where('queue', $team_id);
	$this->db->where('deleted', 0);        

        $query = $this->db->get();
        $rows = $query->result_array();
        
        if (count($rows) > 0)
            return $rows[0]['id_campaign'];
        else 
            return false;
        
    }

    public function maxid_mailing() {

        $this->db->select_max('id');
        $query = $this->db->get('mailing_process');

        $max_id = $query->result_array();

        if (count($max_id) > 0)
            return $max_id[0]['id'];
        else
            return false;
    }
    
    public function mailing_return($id_campaign) {
        
        /*
        $this->db->select("c.phone, ca.value as cid, cdr.calldate, 

	CASE 
            WHEN cdr.disposition = 'ANSWERED'  THEN 1
	    WHEN cdr.disposition = 'NO ANSWER' THEN 2
	    WHEN cdr.disposition = 'BUSY' THEN 3
	    WHEN cdr.disposition = 'CONGESTION' THEN 3
	    WHEN cdr.disposition = 'FAILED' THEN 4
	    WHEN cdr.disposition = 'UNKNOWN' THEN 4
	END
	AS statusid");
        */
        
        $this->db->select("c.phone, ca.value as cid, c.start_time, 

	CASE 
            WHEN c.status = 'Success'   THEN 1
            WHEN c.status = 'ShortCall' THEN 1
	    WHEN c.status = 'NoAnswer'  THEN 2
	    WHEN c.status = 'Abandoned' THEN 3
	    WHEN c.status = 'Failure'   THEN 4
	END
	AS statusid");
        
        $this->db->from('call_center.calls c');
                
        $this->db->join('call_center.call_attribute ca', 'ca.id_call = c.id', 'left');
        
        $this->db->join('asteriskcdrdb.cdr cdr', 'cdr.uniqueid = c.uniqueid', 'left');
        
        $this->db->where("ca.columna = 'CODIGO FINAZ' AND c.uniqueid IS NOT NULL AND c.id_campaign = $id_campaign");
        
        $query = $this->db->get();
        
        return $query->result_array();
    }

}
