<?php

class Ramais {

    private $_log;
    private $_tuberia;
    private $_call = array();
    private $_name = NULL;
    private $_number = NULL;
    private $_status = NULL;
    private $_IPaddress = NULL;
    private $_latency = 0;

    public function __construct($number, $status, $tuberia, $log) {

        $this->_status = (string) $status;
        $this->_number = (string) $number;
        $this->_tuberia = $tuberia;
        $this->_log = $log;
    }

    public function __get($s) {

        switch ($s) {
            case 'number':
                return $this->_number;
                
            case 'call':
                return $this->_call;
                
            case 'status':
                return $this->_status;      
                
            default:
                die(__METHOD__ . ' - propiedad no implementada: ' . $s);
        }
    }

    public function __set($s, $v) {
        
        switch ($s) {
            case 'status':
                $this->_status= (string) $v;
                break;
            
            case 'IPaddress':
                $this->_IPaddress=  $v;
                break;
            
            case 'latency':
                $this->_latency = (int) $v;
                break;
            
            case 'call':
                if (!is_null($s))
                    $this->_call [] = (string) $v;
                break;

            default:
                die(__METHOD__ . ' - propiedad no implementada: ' . $s);
        }
    }
    
    public function dump($log) {
        
        $s = ("\n\t ----- RAMAIS  -----") . "\n";
        $s .= ("\tnumber............." . $this->_nul($this->_number)) . "\n";
        $s .= ("\tstatus............." . $this->_nul($this->_status)) . "\n";
        $s .= ("\tIPaddress.........." . $this->_nul($this->_IPaddress)) . "\n";
        $s .= ("\tlantency..........." . $this->_nul($this->_latency)) . "\n";
        
        if (count($this->_call) > 0 ) 
        $s .= ("\tcalls.............." . implode('|', $this->_call)) . "\n";
           
      
        $log->output($s);
    }
    
    private function _nul($i) { 
        return is_null($i) ? '(ninguno)' : "$i"; 
        
    }
    
    public function delCall($uniqueid) {
        foreach($this->_call as $k => $cl) {
            if ($cl == $uniqueid)
                unset($this->_call[$k]);
        }
    }

}
