<?php

class ListaRamais implements IteratorAggregate {

    private $_tuberia;
    private $_log;
    private $_ramais = array();
    private $_incall = 0;

    public function __construct($tuberia, $log) {

        $this->_tuberia = $tuberia;
        $this->_log = $log;
    }

    function getIterator() {
        return new ArrayIterator($this->_ramais);
    }

    public function addRamal($number, $status) {

        $obj = new Ramais($number, $status, $this->_tuberia, $this->_log);
        $this->_ramais[] = $obj;
        //$this->_log->output("DEVELOPER: " . __METHOD__ . ": Ramal $number add");
        return $obj;
    }
    
    public function addRamalInCall($number, $uniqueid) {
        
        //$this->_ramais[$number][$uniqueid];
        
       // $this->_log->output("DEVELOPER: LISTA RAMAL NUMBER: $number, UNIQUEID: $uniqueid");
        
        foreach ($this->_ramais as $key => $ramal) {
            if ($ramal->number == $number) 
                $this->_ramais[$key]->call = $uniqueid;
        } 
        
        $this->_incall++;

    }
    
    
    public function delRamalInCall($number, $uniqueid) {
        
        //$this->_ramais[$number][$uniqueid];
        
       // $this->_log->output("DEVELOPER: LISTA RAMAL NUMBER: $number, UNIQUEID: $uniqueid");
        
        
        foreach ($this->_ramais as $key => $ramal) { 
            if ($ramal->number == $number) {
                $ramal->delCall($uniqueid);
            }
        }
        
        $this->_incall--;
        
        if ($this->_incall < 0 )
            $this->_incall = 0;
       // $this->dump($this->_log);
    }
    
    public function delRamal($number) {
        
        foreach($this->_ramais as $key => $ramal) {
            
            if ($ramal->number == $number)
                unset($this->_ramais[$key]);
                   
        }
        
    }
    
    public function updatePeerEntryRamal($params) {

        foreach ($this->_ramais as $key => $ramal) {
            if ($params['Dynamic'] == 'yes') {
                if ($ramal->number == $params['ObjectName']) {
                    if (preg_match('/^OK\s\((\d+)\sms\)/', trim($params['Status']), $output)) {
                        $this->_ramais[$key]->status = 'Registered';
                        $this->_ramais[$key]->IPaddress = $params['IPaddress'];
                        $this->_ramais[$key]->latency = trim($output[1]);
                    } else {
                        $this->_ramais[$key]->status = $params['Status'];
                    }
                }
            }
        }
    }

    public function updatePeerStatusRamal($params) {


        $peer = preg_match('/\d.+$/', $params['Peer'], $output);
        $peer = $output[0];

        foreach ($this->_ramais as $key => $ramal) {
            if ($ramal->number == $peer) {
                
                if ($params['PeerStatus'] == 'Unregistered') {
                    $this->_ramais[$key]->status = 'UNKNOWN';
                    $this->_ramais[$key]->IPaddress = NULL;
                    $this->_ramais[$key]->latency = 0;
                    
                    
                }
                
                if ($params['PeerStatus'] == 'Registered') {
                    $this->_ramais[$key]->status = $params['PeerStatus'];
                    $ipaddress = preg_match('/^\d+\.\d+\.\d+\.\d+/', $params['Address'], $output);
                    $this->_ramais[$key]->IPaddress = $output[0];
                    
  
                }
            }
        }

    }
    
    public function getRegistedNotInCall() {

        $i = 0;
        $call = $this->_incall;
        
        foreach ($this->_ramais as  $ramal) {
            
            if ($ramal->status != 'UNKNOWN')
                $i++;
        } 

        return array('max_canales' => $i, "calls" => $call); 
    }


    function dump($log) {
        
        foreach ($this->_ramais as &$ramal)
            $ramal->dump($log);
    }

}
