<?php

class ADVXGestor {
    
    private $_id = 2019001;
    
    private $_res_list_users      = 'https://promobank.com.br/integra/usuarios/v1/';
    
    private $_res_list_clients    = 'https://promobank.com.br/integra/clientes/v1/';
    
    private $_res_enable_dialer   = 'https://promobank.com.br/integra/discar/v1/';
    
    private $_res_status_central  = 'https://promobank.com.br/integra/central/v1/';
   
    private $_res_attended_remote = 'https://promobank.com.br/integra/personalizado/v1/';
    
    private $_active = false;
    
    public function __construct($db, $log) {
        $this->_db = $db;
        $this->_log = $log;
        
        $this->_active = $this->is_active();
    }
    
    public function request($ramal, $idCall) {

        if ($this->_active) {

            $token = $this->get_token();

            $attended = $this->get_typeAttended();

            $call = $this->get_call($idCall);
            $phone = $call['phone'];
            $UID = $call['UID'];


            $url = $this->_res_attended_remote . "?token_empresa=$token&ramal=$ramal&uid=$UID&telefone=$phone&atendimento=$attended&retorno=JSON";

            $this->send_request($url);

            $this->_log->output("INTEGRACAO ADV: " . print_r($url, TRUE));
        } else {
            $this->_log->output("INTEGRACAO ADV: " . print_r('Integração desabilitada', TRUE));
        }
    }

    protected function is_active() {
        
        $status = <<<SQL_FINAZ
SELECT status FROM integrations WHERE name='advgestor' AND id='2019001'
SQL_FINAZ;
        
        $recordset = $this->_db->prepare($status);
        $recordset->execute(array());
        $tupla = $recordset->fetch();
        $recordset->closeCursor();
     
        if ($tupla['status'])
            return true;
        else 
            return false;
        
    }
    
    
    public function get_call($idCall) {

        $sCall = <<<SQL_ADVX
SELECT c.phone, ca.value from calls c
INNER JOIN call_attribute ca ON ca.id_call = c.id
WHERE c.id = ? AND ca.columna = 'UID'
SQL_ADVX;
        
        $recordset = $this->_db->prepare($sCall);
        $recordset->execute(array($idCall));
        $tupla = $recordset->fetch();
        $recordset->closeCursor();

        $UID = $tupla['value'];
        $phone = $tupla['phone'];

                    
        return array(
            'phone' => $phone,
            'UID' => $UID
        );
    }

    public function get_token() {
        
        $typeAttended = <<<SQL_ADVX
SELECT param FROM integrations WHERE id = ?
SQL_ADVX;

        $recordset = $this->_db->prepare($typeAttended);
        $recordset->execute(array('2019001'));
        $tupla = $recordset->fetch();
        $recordset->closeCursor();
        
        $param = json_decode($tupla['param']);
        return $param->token;
    }
    
    public function get_typeAttended() {

        $typeAttended = <<<SQL_ADVX
SELECT param FROM integrations WHERE id = ?
SQL_ADVX;

        $recordset = $this->_db->prepare($typeAttended);
        $recordset->execute(array($this->_id));
        $tupla = $recordset->fetch();
        $recordset->closeCursor();
        
        
        $param = json_decode($tupla['param']);
        
        if ($param->type_attended)
            return 'IMEDIATO';
        
        return 'ESPERA';
    }
    
    protected function send_request($url) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        //curl_setopt($ch, CURLOPT_NOBODY, TRUE); // remove body 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $head = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    }

}