<?php
/* vim: set expandtab tabstop=4 softtabstop=4 shiftwidth=4:
 Codificación: UTF-8
 +----------------------------------------------------------------------+
 | Issabel version 0.5                                                  |
 | http://www.issabel.org                                               |
 +----------------------------------------------------------------------+
 | Copyright (c) 2006 Palosanto Solutions S. A.                         |
 +----------------------------------------------------------------------+
 | The contents of this file are subject to the General Public License  |
 | (GPL) Version 2 (the "License"); you may not use this file except in |
 | compliance with the License. You may obtain a copy of the License at |
 | http://www.opensource.org/licenses/gpl-license.php                   |
 |                                                                      |
 | Software distributed under the License is distributed on an "AS IS"  |
 | basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See  |
 | the License for the specific language governing rights and           |
 | limitations under the License.                                       |
 +----------------------------------------------------------------------+
 | The Initial Developer of the Original Code is PaloSanto Solutions    |
 +----------------------------------------------------------------------+
 $Id: new_campaign.php $ */

class Uploader_Storage
{
    static function main($module_name, $smarty, $local_templates_dir, $pDB)
    {
        global $arrConf;
        
        $pDBStorage = new paloDB($arrConf['cadena_dsn_storage']);
        $oFileList = new FileList($pDBStorage);
        $arrFile = $oFileList->get_file($_POST['id_file']);

        if (isset($_POST['save'])) {
            if (!in_array($_POST['encoding'], mb_list_encodings())) {
                $smarty->assign("mb_title", _tr('Validation Error'));
                $smarty->assign("mb_message", _tr('Invalid character encoding'));
            } elseif (count($arrFile) != 1) {
                $smarty->assign("mb_title", _tr('Validation Error'));
                $smarty->assign("mb_message", _tr('Call file not specified or failed to be uploaded'));
            } else {
                $pDB->beginTransaction();

                // Se puede tardar mucho tiempo en la inserción
                set_time_limit(0);
                list($bExito, $errMsg) = self::addCampaignNumbersFromFile(
                    $pDB,
                    $_REQUEST['id_campaign'],
                   // $_FILES['phonefile']['tmp_name'],
                    $arrConf['path_storage'] . $arrFile[0]['name_storage'] . '.csv',    
                    $_POST['encoding']);

                // Confirmar o deshacer la transacción según sea apropiado
                if ($bExito) {
                    $pDB->commit();
                    header("Location: ?menu=$module_name");
                    return '';
                } else {
                    $pDB->rollBack();
                    $smarty->assign("mb_title", _tr("Validation Error"));
                    $smarty->assign("mb_message", $errMsg);
                }
            }
        }
        

   $pDBStorage = new paloDB($arrConf['cadena_dsn_storage']);
    $oFileList = new FileList($pDBStorage);
    
    
    $arrFiles = $oFileList->get_files();
    
    
   $oGrid = new paloSantoGrid($smarty);
    $oGrid->setLimit(50);
    $oGrid->setTotal(count($arrFiles));
    $offset = $oGrid->calculateOffset();
    
    $arrCampaign = array_slice($arrFiles, $offset, $oGrid->getLimit());

    if (is_array($arrFiles)) {
        foreach ($arrFiles as $file) {
            $arrData[] = array(
                "<input class=\"button\" type=\"radio\" name=\"id_file\" value=\"$file[id]\" />" . "<input  type=\"hidden\" name=\"encoding\" value=\"UTF-8\" />",
                $file['name'],
                $file['type_phone'] == 'all'? 'Fixo e Móvel': ($file['type_phone'] == 'fix'?'Fixo': 'Móvel'),
                $file['order_by'] == 'line'?'Linhas':'Colunas',
                $file['add_zero'] == 0?'Não':'Sim',
                $file['num_contact'],
                formatBytes($file['size']),
                $file['create_at']
                    
            );
        }
    }
    
    $oGrid->setWidth("99%");
    $oGrid->setIcon("images/list.png");
    $oGrid->setColumns(
            array(
                '',
                _tr('Name'), 
                _tr('Type of Phones'),
                _tr('Order by'),
                _tr('Add Zero'),
                _tr('Numbers of Phones'),
                _tr('Size'),  
                _tr('Create at')
                )
            );
  
    $oGrid->setData($arrData);
    return $oGrid->fetchGrid();
    }

    /**
     * Procedimiento para agregar los números de teléfono indicados por la
     * ruta de archivo indicada a la campaña. No se hace intento alguno por
     * eliminar números existentes de la campaña (véase clearCampaignNumbers()), ni
     * tampoco para verificar si los números existentes se encuentran en el
     * listado nuevo definido.
     *
     * @param   int     $idCampaign ID de la campaña a modificar
     * @param   string  $sFilePath  Archivo local a leer para los números
     *
     * @return bool     VERDADERO si éxito, FALSO si ocurre un error
     */
    private static function addCampaignNumbersFromFile($pDB, $idCampaign, $sFilePath, $sEncoding)
    { 
        // Detectar codificación para procesar siempre como UTF-8 (bug #325)
        if (is_null($sEncoding))
            $sEncoding = self::_adivinarCharsetArchivo($sFilePath);

        $hArchivo = fopen($sFilePath, 'rt');
        if (!$hArchivo) {
            return array(FALSE, _tr('Invalid CSV File'));
        }

        $inserter = new paloContactInsert($pDB, $idCampaign);

        if (!$inserter->beforeBatchInsert()) {
            fclose($hArchivo);
            return array(
                FALSE,
                sprintf('(internal) Cannot start batch contact insert - %s',
                    $inserter->errMsg));
        }

        $iNumLinea = 0;
        $clavesColumnas = array();
        
        // Retira Header arquivo
        //$tupla = fgetcsv($hArchivo, 8192, ',');
        
        while ($tupla = fgetcsv($hArchivo, 8192, ',')) {
            $iNumLinea++;
            if (function_exists('mb_convert_encoding')) {
                foreach ($tupla as $k => $v)
                    $tupla[$k] = mb_convert_encoding($tupla[$k], 'UTF-8', $sEncoding);
            }
            $tupla[2] = trim($tupla[2]);
            
            if (count($tupla) == 1 && trim($tupla[1]) == '') {
                // Línea vacía
            } elseif (strlen($tupla[2]) > 0 && $tupla[2]{0} == '#') {
                // Línea que empieza por numeral
            } elseif (!preg_match('/^([\d#\*])+$/', $tupla[2])) {
                if ($iNumLinea == 1) {
                    // Podría ser una cabecera de nombres de columnas
                    array_shift($tupla);
                    $clavesColumnas = $tupla;
        
                    array_shift($clavesColumnas); // Remove DNC
                    array_shift($clavesColumnas); // Remove FONE 
                
                } else {
                    // Teléfono no es numérico
                    fclose($hArchivo);
                    return array(
                        FALSE,
                        _tr('Invalid CSV File Line')." "."$iNumLinea: "._tr('Invalid number')
                    );
                }
            } else {
                $uuid = array_shift($tupla);
                $dnc = array_shift($tupla);
                $numero = array_shift($tupla);

                
                $atributos = array();
                for ($i = 0; $i < count($tupla); $i++) {
                    $atributos[$i + 1] = array(
                        ($i < count($clavesColumnas) && $clavesColumnas[$i] != '') ? $clavesColumnas[$i] : ($i + 1),
                        $tupla[$i],
                    );
                }
                $idCall = $inserter->insertOneContact($uuid, $dnc, $numero, $atributos);
                if (is_null($idCall)) {
                    fclose($hArchivo);
                    return array(
                        FALSE,
                        sprintf('(internal) Cannot insert phone %s at line %d - %s',
                            $numero, $iNumLinea, $inserter->errMsg));
                }
            }
        }
        fclose($hArchivo);

        if (!$inserter->afterBatchInsert()) {
            return array(
                FALSE,
                sprintf('(internal) Cannot close batch contact insert - %s',
                    $inserter->errMsg));
        }

        return array(TRUE, NULL);
    }

    private static function _listarCodificaciones()
    {
        $listaEncodings = array(
            'UTF-8' =>  _tr('UTF-8'),
        );
        $listaPosterior = array();
        foreach (mb_list_encodings() as $sEnc) {
            if (!isset($listaEncodings[$sEnc]) && !isset($listaPosterior[$sEnc]) &&
                !in_array($sEnc, array('pass', 'wchar', 'BASE64', 'UUENCODE',
                    'HTML-ENTITIES', 'Quoted-Printable', 'UTF7-IMAP'))) {
                if ($sEnc != _tr($sEnc))
                    $listaEncodings[$sEnc] = _tr($sEnc);
                else $listaPosterior[$sEnc] = _tr($sEnc);
            }
        }
        $listaEncodings = array_merge($listaEncodings, $listaPosterior);
        return $listaEncodings;
    }

    // Función que intenta adivinar la codificación de caracteres del archivo
    private static function _adivinarCharsetArchivo($sFilePath)
    {
        if (!function_exists('mb_detect_encoding')) return 'UTF-8';

        // Agregar a lista para detectar más encodings. ISO-8859-15 debe estar
        // al último porque toda cadena de texto es válida como ISO-8859-15.
        $listaEncodings = array(
            "ASCII",
            "UTF-8",
            //"EUC-JP",
            //"SJIS",
            //"JIS",
            //"ISO-2022-JP",
            "ISO-8859-15"
        );
        //$sContenido = file_get_contents($sFilePath);

        // Ya no se usa file_get_contents() porque el archivo puede ser muy grande
        $hArchivo = fopen($sFilePath);
        if (!$hArchivo) return 'UTF-8';
        for ($i = 0; $i < 20 && !feof($hArchivo); $i++) $sContenido .= fgets($hArchivo);
        fclose($hArchivo);
        $sEncoding = mb_detect_encoding($sContenido, $listaEncodings);
        return $sEncoding;
    }
    
        public static function addCampaignNumbersFromFileRepeat($pDB, $idCampaign, $sFilePath, $sEncoding) { 
 
            $pDB->beginTransaction();
            list($bExito, $errMsg) = self::addCampaignNumbersFromFile($pDB, $idCampaign, $sFilePath, $sEncoding) ;
            
            if ($bExito) {
                    $pDB->commit();
                   // header("Location: ?menu=$module_name");
                    return true;
                } else {
                    $pDB->rollBack();
                    return false;
                }
        }
 
}
