<?php

/* vim: set expandtab tabstop=4 softtabstop=4 shiftwidth=4:
  Codificación: UTF-8
  +----------------------------------------------------------------------+
  | Issabel version 0.5                                                  |
  | http://www.issabel.org                                               |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006 Palosanto Solutions S. A.                         |
  +----------------------------------------------------------------------+
  | The contents of this file are subject to the General Public License  |
  | (GPL) Version 2 (the "License"); you may not use this file except in |
  | compliance with the License. You may obtain a copy of the License at |
  | http://www.opensource.org/licenses/gpl-license.php                   |
  |                                                                      |
  | Software distributed under the License is distributed on an "AS IS"  |
  | basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See  |
  | the License for the specific language governing rights and           |
  | limitations under the License.                                       |
  +----------------------------------------------------------------------+
  | The Initial Developer of the Original Code is PaloSanto Solutions    |
  +----------------------------------------------------------------------+
  $Id: index.php,v 1.1.1.1 2007/07/06 21:31:21 gcarrillo Exp $ */

require_once "libs/paloSantoGrid.class.php";
require_once "libs/paloSantoDB.class.php";
require_once "libs/paloSantoForm.class.php";
require_once "libs/paloSantoConfig.class.php";
require_once "libs/paloSantoQueue.class.php";
require_once "libs/misc.lib.php";

require_once "modules/agent_console/libs/issabel2.lib.php";

function _moduleContent(&$smarty, $module_name) {
    //include module files
    include_once "modules/$module_name/configs/default.conf.php";
    include_once "modules/$module_name/libs/paloSantoCallsDetail.class.php";
    global $arrConf;

    load_language_module($module_name);

    //folder path for custom templates
    $base_dir = dirname($_SERVER['SCRIPT_FILENAME']);
    $templates_dir = (isset($arrConfig['templates_dir'])) ? $arrConfig['templates_dir'] : 'themes';
    $local_templates_dir = "$base_dir/modules/$module_name/" . $templates_dir . '/' . $arrConf['theme'];

    $pDB = new paloDB($cadena_dsn);

    // $contenidoModulo = '';
    switch (getParameter('action')) {
        case 'csv_data':
            // return downloadRecording($smarty, $module_name, $pDB);
            $contenidoModulo =  displayCampaignCSV($pDB, $smarty, $module_name, $local_templates_dir);
            ob_end_clean();
            echo $contenidoModulo; exit;
        default:
            $contenidoModulo = reportCallsDetail($smarty, $module_name, $pDB, $local_templates_dir);
            break;
    }
// echo $contenidoModulo; exit;
    return $contenidoModulo;
}

function reportCallsDetail($smarty, $module_name, $pDB, $local_templates_dir) {

    // Cadenas estáticas de Smarty
    $smarty->assign(array(
        "Filter" => _tr('Filter'),
        "SHOW" => _tr("Show"),
    ));

    $bIssabelNuevo = method_exists('paloSantoGrid', 'setURL');

    // Variables iniciales para posición de grid
    $offset = 0;
    $limit = 50;
    $total = 0;

    // Para poder consultar las colas activas
    $pConfig = new paloConfig("/etc", "amportal.conf", "=", "[[:space:]]*=[[:space:]]*");
    $ampconfig = $pConfig->leer_configuracion(false);
    $ampdsn = $ampconfig['AMPDBENGINE']['valor'] . "://" . $ampconfig['AMPDBUSER']['valor'] .
            ":" . $ampconfig['AMPDBPASS']['valor'] . "@" . $ampconfig['AMPDBHOST']['valor'] . "/asterisk";

    // Para poder consultar los agentes de campañas
    $oCallsDetail = new paloSantoCallsDetail($pDB); 
   

    if (isset($_POST['delete'])) {

         
        if (!hasModulePrivilege($user, $module_name, 'deleteany')){
            $smarty->assign("mb_title", 'You do not have permission');
            Header("Location: ?menu=$module_name");
        }

        if (!isset($_POST['date_start']))
            $_POST['date_start']= date("d M Y");
        if (!isset($_POST['date_end']))
            $_POST['date_end'] = date("d M Y");

        if (validarData($_POST['date_start']) && validarData($_POST['date_end']) && $oCallsDetail->deleteReports($_POST['date_start'], $_POST['date_end'])) {
            $smarty->assign("mb_title", _tr('Message'));
            $smarty->assign("mb_message", _tr('Deleted successfully'));
        } else {
            $smarty->assign("mb_title", _tr('Delete Error'));
            $smarty->assign("mb_message", _tr('Error when deleting') . $msg_error);
        } 
    }

    $urlVars = array('menu' => $module_name);
    
    $arrFormElements = createFieldFilter2(); 
    
    $oFilterForm = new paloForm($smarty, $arrFormElements);

    // Validar y aplicar las variables de filtro
    $paramLista = NULL;
    $paramFiltro = array();
    foreach (array('date_start', 'date_end') as $k)
        $paramFiltro[$k] = getParameter($k);

    if (!isset($paramFiltro['date_start']))
        $paramFiltro['date_start'] = date("d M Y");
    if (!isset($paramFiltro['date_end']))
        $paramFiltro['date_end'] = date("d M Y");

    if (!$oFilterForm->validateForm($paramFiltro)) {
        // Hay un error al validar las variables del filtro
        $smarty->assign("mb_title", _tr("Validation Error"));
        $arrErrores = $oFilterForm->arrErroresValidacion;
        $strErrorMsg = "<b>" . _tr('The following fields contain errors') . ":</b><br>";
        $strErrorMsg = implode(', ', array_keys($arrErrores));
        $smarty->assign("mb_message", $strErrorMsg);
    } else {
        $urlVars = array_merge($urlVars, $paramFiltro);
        $paramLista = $paramFiltro;
        $paramLista['date_start'] = translateDate($paramFiltro['date_start']) . " 00:00:00";
        $paramLista['date_end'] = translateDate($paramFiltro['date_end']) . " 23:59:59";
    }
    
    $htmlFilter = $oFilterForm->fetchForm("$local_templates_dir/filter.tpl", "", $paramFiltro);

    // Inicio de objeto grilla y asignación de filtro
    $oGrid = new paloSantoGrid($smarty);
    $oGrid->showFilter($htmlFilter);

    $user = isset($_SESSION['issabel_user'])?$_SESSION['issabel_user']:"";

    if (hasModulePrivilege($user, $module_name, 'downloadcsv')){
        $oGrid->customAction("?menu=$module_name&action=csv_data",_tr('Download .CSV'),"", true);
    }

    if (hasModulePrivilege($user, $module_name, 'deleteany')){
        $oGrid->deleteList(_tr('Tem certeza de que deseja excluir?'), 'delete', _tr('Delete'));
    }
    // Ejecutar la consulta con las variables ya validadas
    $arrData = array();
    $total = 0;

    if (is_array($paramLista)) {
        $total = $oCallsDetail->contarDetalleLlamadas($paramLista);

        if (is_null($total)) {
            $smarty->assign("mb_title", _tr("Error when connecting to database"));
            $smarty->assign("mb_message", $oCallsDetail->errMsg);
            $total = 0;
        } else {
            // Habilitar la exportación de todo el contenido consultado
            if ($bExportando)
                $limit = $total;


            // Calcular el offset de la petición de registros
            if ($bIssabelNuevo) {
                $oGrid->setLimit($limit);
                $oGrid->setTotal($total);
                $offset = $oGrid->calculateOffset();
            } else {
                // Si se quiere avanzar a la sgte. pagina
                if (isset($_GET['nav']) && $_GET['nav'] == "end") {
                    // Mejorar el sgte. bloque.
                    if (($total % $limit) == 0) {
                        $offset = $total - $limit;
                    } else {
                        $offset = $total - $total % $limit;
                    }
                }

                // Si se quiere avanzar a la sgte. pagina
                if (isset($_GET['nav']) && $_GET['nav'] == "next") {
                    $offset = $_GET['start'] + $limit - 1;
                }

                // Si se quiere retroceder
                if (isset($_GET['nav']) && $_GET['nav'] == "previous") {
                    $offset = $_GET['start'] - $limit - 1;
                }
            }
            // Ejecutar la consulta de los datos en el offset indicado
            $recordset = $oCallsDetail->leerDetalleLlamadas($paramLista, $limit, $offset); 
            if (!is_array($recordset)) {
                $smarty->assign("mb_title", _tr("Error when connecting to database"));
                $smarty->assign("mb_message", $oCallsDetail->errMsg);
                $total = 0;
            } else {
                foreach ($recordset as $cdr) {
                    
                     $tupla = array(
                        $cdr[0],
                        $cdr[1], 
                        $cdr[2],
                        $cdr[3],
                        $cdr[4],
                        mascararCPF($cdr[5]),
                    );

                    $arrData[] = $tupla;
                }
            }
        }
    }

    $arrColumnas = array( 
        _tr("Data"),
        _tr('Campanha'),
        _tr("Tecla Descricao"),
        _tr("Tecla Digito"),
        _tr("Telefone"),
        _tr('CPF'),
    );

    if ($bIssabelNuevo) {
        $oGrid->addFilterControl(_tr("Filter applied: ") . _tr("Start Date") . " = " . $paramLista['date_start'] . ", " . _tr("End Date") . " = " .
                $paramLista['date_end'], $paramLista, array('date_start' => date("d M Y"), 'date_end' => date("d M Y")), true);

        $oGrid->setURL(construirURL($urlVars, array("nav", "start")));
        $oGrid->setData($arrData);
        $oGrid->setColumns($arrColumnas);
        $oGrid->setTitle(_tr("Calls Detail"));
        $oGrid->pagingShow(true);
        $oGrid->setNameFile_Export(_tr("Calls Detail"));

        return $oGrid->fetchGrid();
    } else {
        global $arrLang;

        $url = construirURL($urlVars, array("nav", "start"));

        function _map_name($s) {
            return array('name' => $s);
        }

        $arrGrid = array("title" => _tr("Calls Detail"),
            "url" => $url,
            "icon" => "images/user.png",
            "width" => "99%",
            "start" => ($total == 0) ? 0 : $offset + 1,
            "end" => ($offset + $limit) <= $total ? $offset + $limit : $total,
            "total" => $total,
            "columns" => array_map('_map_name', $arrColumnas),
        );

        return $sContenido;
    }
}

function displayCampaignCSV($pDB, $smarty, $module_name, $local_templates_dir) {
    $user = isset($_SESSION['issabel_user'])?$_SESSION['issabel_user']:"";
    
    if (!hasModulePrivilege($user, $module_name, 'downloadcsv')){
        $smarty->assign("mb_title", 'You do not have permission');
        Header("Location: ?menu=$module_name");
    }
   
    $arrFormElements = createFieldFilter2(); 
    
    $oFilterForm = new paloForm($smarty, $arrFormElements);
    $oCallsDetail = new paloSantoCallsDetail($pDB); 

    // Validar y aplicar las variables de filtro
    $paramLista = NULL;
    $paramFiltro = array();
    foreach (array('date_start', 'date_end') as $k)
        $paramFiltro[$k] = getParameter($k);

    if (!isset($paramFiltro['date_start']))
        $paramFiltro['date_start'] = date("d M Y");
    if (!isset($paramFiltro['date_end']))
        $paramFiltro['date_end'] = date("d M Y");


    if (!$oFilterForm->validateForm($paramFiltro)) {
     
        // Hay un error al validar las variables del filtro
        $smarty->assign("mb_title", _tr("Validation Error"));
        $arrErrores = $oFilterForm->arrErroresValidacion;
        $strErrorMsg = "<b>" . _tr('The following fields contain errors') . ":</b><br>";
        $strErrorMsg = implode(', ', array_keys($arrErrores));
        $smarty->assign("mb_message", $strErrorMsg);
    } else {
        $urlVars = array_merge($urlVars, $paramFiltro);
        $paramLista = $paramFiltro;
        $paramLista['date_start'] = translateDate($paramFiltro['date_start']) . " 00:00:00";
        $paramLista['date_end'] = translateDate($paramFiltro['date_end']) . " 23:59:59";
    }
  

    if (is_array($paramLista)) {
        $total = $oCallsDetail->contarDetalleLlamadas($paramLista);
        $limit = $total;
        $offset = 0;
        ini_set('max_execution_time', 3600);
        $errMsg = NULL;
        $datosCampania = $oCallsDetail->leerDetalleLlamadas($paramLista, $limit, $offset);
 
        if (is_null($datosCampania)) {
            print $oCamp->errMsg;
        } else {

            header("Cache-Control: private");
            header("Pragma: cache");
            header('Content-Type: text/csv; charset=UTF-8; header=present');
            header("Content-disposition: attachment; filename=\"Relatorio_Retorno-" . $paramLista['date_start'] . "_" . $paramLista['date_end'] . ".csv\"");

            $baseLabels = array("Data", "Campanha", "Tecla Descrição", "Tecla Dígito", "Telefone", "CPF");
            $baseLabels = addAspasDuplas($baseLabels);
            $sDatosCSV = join(';', $baseLabels)."\r\n";

            if (count($datosCampania) <= 0) {
                $sDatosCSV = "No Data Found\r\n";
            } else {
                

                $lineaCSV = array();
                // Datos del archivo CSV
                foreach ($datosCampania as $tuplaDatos) {
                    $tuplaDatos[5] = mascararCPF($tuplaDatos[5]);
                    $tuplaDatos = addAspasDuplas($tuplaDatos);
                    $sDatosCSV .= join(';', $tuplaDatos)."\r\n";
                }
            }

        }
    }
    
    return $sDatosCSV;
}

function mascararCPF($cpf) {
    $cpf = preg_replace('/\D/', '', $cpf);

    if(strlen($cpf) !== 11){
        return 'CPF inválido';
    }

    $cpfMascarado = substr($cpf, 0, 3) . '.' . substr($cpf, 3, 3) . '.***-**';

    return $cpfMascarado;
}

function addAspasDuplas($line) {
    return array_map(function($e) {
        return '"' . $e . '"';
    }, $line);
}

function validarData($data) {
    $dateTime = DateTime::createFromFormat('d M Y', $data);
    return  $dateTime && $dateTime->format('d M Y') === $data;

    return true;
}

function downloadRecording($smarty, $module_name, $pDB) {
    if (!isset($_GET['id'])) {
        Header('Location: ?menu=' . $module_name);
        return;
    }

    $oCallsDetail = new paloSantoCallsDetail($pDB);
    $path = $oCallsDetail->getRecordingFilePath($_GET['id']);
    if (is_null($path)) {
        if ($oCallsDetail->errMsg != '') {
            Header('HTTP/1.1 503 Internal Server Error');
            return $oCallsDetail->errMsg;
        } else {
            Header('HTTP/1.1 404 Not Found');
            return 'Not Found';
        }
    } elseif (!file_exists($path[0])) {
        if (substr($path[0], -6) == '.wav49') {
            // Archivo .wav49 realmente tiene extensión .WAV
            $path[0] = substr($path[0], 0, strlen($path[0]) - 6) . '.WAV';
            $path[1] = substr($path[1], 0, strlen($path[1]) - 6) . '.WAV';
            if (!file_exists($path[0])) {
                Header('HTTP/1.1 404 Not Found');
                return 'Not Found';
            }
        } else {
            Header('HTTP/1.1 404 Not Found');
            return 'Not Found';
        }
    }

    // Establecer Content-Type
    $content_type = 'application/octet-stream';
    $contentTypes = array(
        'wav' => 'audio/wav',
        'WAV' => 'audio/wav', // realmente es GSM envuelto en RIFF
        'gsm' => 'audio/gsm',
        'mp3' => 'audio/mpeg',
    );
    $extension = substr(strtolower($path[0]), -3);
    if (isset($contentTypes[$extension])) {
        $content_type = $contentTypes[$extension];
    }

    $path_tmp = '/var/spool/asterisk/tmp/';

    $file_tmp = $path_tmp . basename($path[0], '.'.$extension ) . '.mp3';

    // Convert .gsm to .mp3
    exec("ffmpeg -i  $path[0] -ar 8000 -ac 1 $file_tmp");
    
    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Cache-Control: public");
    header("Content-Description: wav file");
    header("Content-Type: audio/mpeg3");
    header("Content-Disposition: attachment; filename=" . basename($file_tmp));
    header("Content-Transfer-Encoding: binary");
    header("Content-length: " . filesize($file_tmp));

    readfile($file_tmp);
    unlink($file_tmp);
    
}

function createFieldFilter($comboRamais, $comboColas, $arrCallType, $campaignIn, $campaignOut) {
    // Combo de campañas entrantes
    $comboCampaignIn = array('' => '(' . _tr('All Incoming Campaigns') . ')');
    foreach ($campaignIn as $tuplaCampania) {
        $comboCampaignIn[$tuplaCampania['id']] = (($tuplaCampania['estatus'] != 'A') ? '(' . $tuplaCampania['estatus'] . ') ' : '') .
                $tuplaCampania['name'];
    }

    // Combo de campañas salientes
    $comboCampaignOut = array('' => '(' . _tr('All Outgoing Campaigns') . ')');
    foreach ($campaignOut as $tuplaCampania) {
        $comboCampaignOut[$tuplaCampania['id']] = (($tuplaCampania['estatus'] != 'A') ? '(' . $tuplaCampania['estatus'] . ') ' : '') .
                $tuplaCampania['name'];
    }

    $arrFormElements = array(
        "date_start" => array(
            "LABEL" => _tr('Start Date'),
            "REQUIRED" => "yes",
            "INPUT_TYPE" => "DATE",
            "INPUT_EXTRA_PARAM" => "",
            "VALIDATION_TYPE" => "ereg",
            "VALIDATION_EXTRA_PARAM" => "^[[:digit:]]{1,2}[[:space:]]+[[:alnum:]]{3}[[:space:]]+[[:digit:]]{4}$"),
        "date_end" => array(
            "LABEL" => _tr("End Date"),
            "REQUIRED" => "yes",
            "INPUT_TYPE" => "DATE",
            "INPUT_EXTRA_PARAM" => "",
            "VALIDATION_TYPE" => "ereg",
            "VALIDATION_EXTRA_PARAM" => "^[[:digit:]]{1,2}[[:space:]]+[[:alnum:]]{3}[[:space:]]+[[:digit:]]{4}$"),
        // 'ramal' => array(
        //     'LABEL' => _tr('No.Exten'),
        //     'REQUIRED' => 'no',
        //     'INPUT_TYPE' => 'SELECT',
        //     'INPUT_EXTRA_PARAM' => $comboRamais,
        //     'VALIDATION_TYPE' => 'ereg',
        //     'VALIDATION_EXTRA_PARAM' => '^[[:digit:]]+$',
        //     'ONCHANGE' => 'submit();',
        // ),
        /*
        'queue' => array(
            'LABEL' => _tr('Queue'),
            'REQUIRED' => 'no',
            'INPUT_TYPE' => 'SELECT',
            'INPUT_EXTRA_PARAM' => $comboColas,
            'VALIDATION_TYPE' => 'ereg',
            'VALIDATION_EXTRA_PARAM' => '^[[:digit:]]+$',
            'ONCHANGE' => 'submit();',
        ),*/
        /*
        'calltype' => array(
            'LABEL' => _tr('Type'),
            'REQUIRED' => 'no',
            'INPUT_TYPE' => 'SELECT',
            'INPUT_EXTRA_PARAM' => $arrCallType,
            'VALIDATION_TYPE' => 'ereg',
            'VALIDATION_EXTRA_PARAM' => '^(incoming|outgoing)?$',
            'ONCHANGE' => 'submit();',
        ),
         * 
         */
        // 'phone' => array(
        //     'LABEL' => _tr('Phone'),
        //     'REQUIRED' => 'no',
        //     'INPUT_TYPE' => 'TEXT',
        //     'INPUT_EXTRA_PARAM' => '',
        //     'VALIDATION_TYPE' => 'ereg',
        //     'VALIDATION_EXTRA_PARAM' => '^[[:digit:]]+$',
        // ),
        /*
        'id_campaign_in' => array(
            'LABEL' => _tr('Incoming Campaign'),
            'REQUIRED' => 'no',
            'INPUT_TYPE' => 'SELECT',
            'INPUT_EXTRA_PARAM' => $comboCampaignIn,
            'VALIDATION_TYPE' => 'ereg',
            'VALIDATION_EXTRA_PARAM' => '^[[:digit:]]+$',
            'ONCHANGE' => 'submit();',
        ),
         * 
         */
        // 'id_campaign_out' => array(
        //     'LABEL' => _tr('Outgoing Campaign'),
        //     'REQUIRED' => 'no',
        //     'INPUT_TYPE' => 'SELECT',
        //     'INPUT_EXTRA_PARAM' => $comboCampaignOut,
        //     'VALIDATION_TYPE' => 'ereg',
        //     'VALIDATION_EXTRA_PARAM' => '^[[:digit:]]+$',
        //     'ONCHANGE' => 'submit();',
        // ),
    );
    return $arrFormElements;
}

function createFieldFilter2() {

    $arrFormElements = array(
        "date_start" => array(
            "LABEL" => _tr('Start Date'),
            "REQUIRED" => "yes",
            "INPUT_TYPE" => "DATE",
            "INPUT_EXTRA_PARAM" => "",
            "VALIDATION_TYPE" => "ereg",
            "VALIDATION_EXTRA_PARAM" => "^[[:digit:]]{1,2}[[:space:]]+[[:alnum:]]{3}[[:space:]]+[[:digit:]]{4}$"),
        "date_end" => array(
            "LABEL" => _tr("End Date"),
            "REQUIRED" => "yes",
            "INPUT_TYPE" => "DATE",
            "INPUT_EXTRA_PARAM" => "",
            "VALIDATION_TYPE" => "ereg",
            "VALIDATION_EXTRA_PARAM" => "^[[:digit:]]{1,2}[[:space:]]+[[:alnum:]]{3}[[:space:]]+[[:digit:]]{4}$"),
    );
    return $arrFormElements;
}

function formatoSegundos($iSeg) {
    $iHora = $iMinutos = $iSegundos = 0;
    $iSegundos = $iSeg % 60;
    $iSeg = ($iSeg - $iSegundos) / 60;
    $iMinutos = $iSeg % 60;
    $iSeg = ($iSeg - $iMinutos) / 60;
    $iHora = $iSeg;
    return sprintf('%02d:%02d:%02d', $iHora, $iMinutos, $iSegundos);
}

function hasModulePrivilege($user, $module, $privilege) {
    global $arrConf;

    $pDB = new paloDB($arrConf['issabel_dsn']['acl']);
    $pACL = new paloACL($pDB);

    if (method_exists($pACL, 'hasModulePrivilege'))
        return $pACL->hasModulePrivilege($user, $module, $privilege);

    $isAdmin = ($pACL->isUserAdministratorGroup($user) !== FALSE);
    return ($isAdmin && in_array($privilege, array(
                'downloadcsv', 
                'deleteany',
    )));
}
