<?php 

defined('BASEPATH') OR exit('No direct script access allowed');

if ( ! function_exists('format_byte'))
{

    function format_byte($size, $precision = 2) {
        $base = log($size, 1024);
        $suffixes = array('bytes', 'K', 'M', 'G', 'T');

        return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
    }
}


if ( ! function_exists('out_replace'))
{

    function out_replace($str, $values, $position) {

        $pattern = array();
        $replacement = array();

        foreach ($position as $key => $val) {
            $pattern[] = "/{{" . $key . "}}/i";
            $replacement[] = $values[$position[$key]];
        }


        return preg_replace($pattern, $replacement, $str);
    }
}


if ( ! function_exists('validar_tel'))
{

    function validar_tel($tel) { 

        $tel = preg_replace('/^0+/', '', (string) $tel);
        
        if(preg_match("/^[1-9][1-9][1-5]\d{7}$/", $tel)) 
            return true;
        else 
            return false;
    }
}


if ( ! function_exists('validar_cel'))
{

    function validar_cel($cel) {
    
        $cel = preg_replace('/^0+/', '', (string) $cel);
       
       if(preg_match("/^[1-9][1-9][2-9]\d{8}$/", $cel)) 
           return true;
       else false;
   }
}