<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

        
class Api extends REST_Controller {

    /* Types: csv, json */
    private $_mailing_post_type = 'csv';


    function __construct() {

        parent::__construct();

        $this->load->library('form_validation');
        $this->load->database();
        $this->load->helper(
            array('api')
        );
    }

    public function calls_post() {

        $config = array(
            'manager_user' => $this->config->item('manager_user'),
            'manager_pass' => $this->config->item('manager_pass')
        );

        $this->load->library("AGI_AsteriskManager", $config);

        $data = array(
            'exten' => $this->get('exten'),
            'phone' => $this->get('phone')
        );

        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('exten', 'Ramal', 'trim|required|integer|min_length[2]|max_length[7]');
        $this->form_validation->set_rules('phone', 'Telefone', 'trim|required|integer|min_length[8]|max_length[12]');

        if ($this->form_validation->run() == FALSE) {
            // TODO: acertar o erro
            $http_response = array();
            $http_code = REST_Controller::HTTP_METHOD_NOT_ALLOWED;
        } else {

            $time = time();
            $actionID = 'WS-' . $time;
            $params = array(
                'ActionID' => $actionID,
                'Channel' => 'SIP/' . $this->get('exten'),
                'Context' => 'from-internal',
                'Exten' => $this->get('phone'),
                'CallerID' => 'Grupo Voip',
                'Priority' => '1',
                'Timeout' => '30000'
            );

            $this->agi_asteriskmanager->connect();

            $response = $this->agi_asteriskmanager->Originate(
                    'SIP/' . $this->get('exten'),
                    $this->get('phone'),
                    ' from-internal',
                    '1',
                    NULL,
                    NULL,
                    '30000',
                    'Grupo Voip',
                    NULL,
                    NULL,
                    true,
                    $actionID
            );

            $event = true;
            $uniqueid = false;
            $timeout = false;
            
            while ($event) {
                $str = fgets($this->agi_asteriskmanager->socket);

                if (preg_match('/^Event: OriginateResponse/', trim($str), $matches)) {

                    $str = fgets($this->agi_asteriskmanager->socket);
                    $action = fgets($this->agi_asteriskmanager->socket);
                    $response = fgets($this->agi_asteriskmanager->socket);
                    
                    if(preg_match("/^Response: Failure$/", trim($response), $matches)) {
                        $event = false;
                        $timeout = true;
                    }    

                    if (preg_match("/^ActionID: $actionID$/", trim($action), $matches) && preg_match("/^Response: Success$/", trim($response), $matches)) { 
                        for ($i = 0; $i < 5; $i++) {
                            $str = fgets($this->agi_asteriskmanager->socket);
                        }
                        
                        if (preg_match('/.+\s(.+)/', $str, $matches)) { 
                            $uniqueid = trim($matches[1]);  
                            $event = false;
                        }
                    }
                }

                if (intval(time()) - intval($time) > 30) {
                    $event = false;
                    $timeout = true;
                }   
            }

            $this->agi_asteriskmanager->disconnect();

            if ($uniqueid) {
                $http_response = array(
                    'data' => array (
                        'type' => 'calls',
                        'id' => (string) $uniqueid
                    )
                );
                $http_code = REST_Controller::HTTP_ACCEPTED ;
                
            } elseif ($timeout) {
                $http_response = array();
                $http_code = REST_Controller::HTTP_REQUEST_TIMEOUT;
            }else {
                $http_response = array();
                $http_code = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
            }
        }

        $this->response($http_response, $http_code);
    }

    public function files_post() {

        // default values
        $http_response = array();
        $http_code = REST_Controller::HTTP_OK;

        if ($_FILES['file_csv']['name'] == '') {
            $http_response = array('error' => 'file missing' );
            $this->response($http_response,REST_Controller::HTTP_BAD_REQUEST);
        }

        $filename = $_FILES['file_csv']['name'];
        $fileext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        if ($fileext != 'csv') {
            $http_response = array('error' => 'file csv missing');
            $this->response($http_response, REST_Controller::HTTP_BAD_REQUEST);
        }


        if ($handle = fopen($_FILES['file_csv']['tmp_name'], "r")) {

            if (!($_FILES['file_csv']['size'] <= 10000000)) {
                // echo "O tamanho do arquivo é maior que 10MB.";
                $http_response = array('error' => 'file has exceeded the size of 10mb');
                $this->response($http_response, REST_Controller::HTTP_BAD_REQUEST);
            }

            switch ($_POST['phone_type']){
                case 'all':
                    $phone_type = 'all';
                    break;
                case 'fixed':
                    $phone_type = 'fix';
                    break;
                case 'movel':
                    $phone_type = 'movel';
                    break;
                default:
                    $phone_type = 'all';
            }
            
            switch ($_POST['order_by']){
                case 'line':
                    $order_by = 'line';
                    break;
                case 'column':
                    $order_by = 'column';
                    break;
                default:
                    $order_by = 'column';
            }
            
            switch ($_POST['add_zero']){
                case 0:
                    $add_zero = FALSE;
                    break;
                case 1:
                    $add_zero = TRUE;
                    break;
                default:
                    $add_zero = TRUE;
            }
          
            $line_header = fgetcsv($handle, 4096, ';');

            // Mapear colunas
            $header_required = array();
            $header_optional = array();

            $fones = array();
            $cpfs = array();

            foreach ($line_header as $key => $value) {
                $header_original[] = $value;
    
                if (substr_count(strtoupper($value), 'NOME') || substr_count(strtoupper($value), 'CLIENT')) {
                    $header_optional['NOME'] = $key;
                    continue;
                }
    
                if (substr_count(strtoupper($value), 'CPF')) {
                    $header_optional ['CPF'] = $key;
                    continue;
                }
    
                if (substr_count(strtoupper($value), 'DDD')) {
                    $header_required ['DDD'][] = $key;
                    continue;
                }
    
                if (substr_count(strtoupper($value), 'FONE') || substr_count(strtoupper($value), 'TEL') || substr_count(strtoupper($value), 'CEL') || substr_count(strtoupper($value), 'MOVEL')) {
                    $header_required ['FONE'][] = $key;
                    continue;
                }
    
                if (substr_count(strtoupper($value), 'NB') || substr_count(strtoupper($value), 'BENEF') || substr_count(strtoupper($value), 'INSS')) {
                    $header_optional ['NB'] = $key;
                    continue;
                }
    
                if (substr_count(strtoupper($value), 'NASC')) {
                    $header_optional ['NASC'] = $key;
                    continue;
                }
    
                // Descarta o field UUID caso tenha
                if (substr_count(strtoupper($value), 'UUID')) {
                    continue;
                }
                
                if (substr_count(strtoupper($value), 'DNC')) {
                    continue;
                }
                
                
                $header_optional[strtoupper($value)] = $key;
            }

            if ( !isset($header_required['FONE'])) {
                $http_response = array('error' => 'column fone required');
                $this->response($http_response, REST_Controller::HTTP_BAD_REQUEST);
            }

            $header_out = array_merge($header_required, $header_optional);
            unset($header_out['FONE']);
            unset($header_out['DDD']);
            
            $output_file= 'UUID,DNC,FONE,' . implode(',', array_keys($header_optional)) . "\r\n";

            $ddd = false;
            if (array_key_exists('DDD', $header_required) &&count($header_required['DDD']) > 0)
                $ddd = true;

            $this->load->library('uuid');
            $Uuid = new Uuid();
            $count = 0;
            $output = '';

            while (($line = fgetcsv($handle, 4096, ';')) !== FALSE) {

                $uuid_line = $Uuid->v4();
                $dnc = 0;
                if ($ddd) {
    
                    foreach ($header_required['DDD'] as $ddd_key => $ddd_value) {
    
                        $arr_data = array();
                        if (!empty($line[$ddd_value]) && !empty($line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]])) {
    
                            $fone = $line[$ddd_value] . $line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]];
                            
                            if ($fone[0] !== '0')
                                $fone = '0' . $line[$ddd_value] . $line[$header_required['FONE'][array_search($ddd_value, $header_required['DDD'])]];
                            
                            $fone = preg_replace('/[^0-9]/', '', (string) $fone);
    
                            if (strlen($fone) < 10) continue;
    
                             // Filter phone type
                            if ($phone_type == 'fix') {
                                if (!validar_tel($fone)) continue;  
                            }
                            else if ($phone_type == 'movel')
                                if (!validar_cel($fone)) continue;
                            
                            // Add or slice zero    
                            if ($fone[0] !== '0') {
                                if ($add_zero)
                                    $fone = '0' . $fone;
                            } else {
                                if (!$add_zero)
                                    $fone = preg_replace('/^0+/', '', (string) $fone);
                            }
                            
                            if (!$fones[$fone] || (!validar_tel($fone) && !validar_cel($fone))) {
                                $arr_data [] = $uuid_line;
                                $arr_data [] = $dnc;
                                $dnc++;
                                $arr_data[] = $fone;
                                $count++;
    
                                foreach ($header_optional as $optk => $optv)
                                    $arr_data[] = out_replace($line[$header_optional[$optk]], $line, $header_out);
    
                                // Order by line or column
                                if ($order_by == 'line')
                                    $output .= implode(',', $arr_data) . "\r\n";
                                else if ($order_by == 'column')
                                    $output[$fonek] .= implode(',', $arr_data) . "\r\n";
    
                                $fones[$fone] = 1;
                            }
                        }
                    }
                } else {
                   // $dnc = false;
                    foreach ($header_required['FONE'] as $fonek => $fonev) {
                        $arr_data = array();
                        if (!empty($line[$fonev])) {
    
                            $fone = $line[$fonev];
                            
                            $fone = preg_replace('/[^0-9]/', '', (string) $fone);
        
                            if (strlen($fone) < 10) continue;
                            
                            // Filter phone type
                            if ($phone_type == 'fix') {
                                if (!validar_tel($fone)) continue;  
                            }
                            else if ($phone_type == 'movel')
                                if (!validar_cel($fone)) continue;
                            
                            // Add or slice zero    
                            if ($fone[0] !== '0') {
                                if ($add_zero)
                                    $fone = '0' . $fone;
                            } else {
                                if (!$add_zero)
                                    $fone = preg_replace('/^0+/', '', (string) $fone);
                            }
    
                            
                            if (!array_key_exists($fone, $fones)|| (!validar_tel($fone) && !validar_cel($fone))) {
                            // if (!in_array($fone, $fones)) {     
                                $arr_data [] = $uuid_line;
                                $arr_data [] = $dnc; 
                                $dnc++;
                                $arr_data[] = $fone; 
                                $count++;
    
                                foreach ($header_optional as $optk => $optv)
                                    $arr_data[] = out_replace($line[$header_optional[$optk]], $line, $header_out);
    
                                // Order by line or column
                                if ($order_by == 'line')
                                    $output .= implode(',', $arr_data) . "\r\n";
                                else if ($order_by == 'column')
                                    $output[$fonek] .= implode(',', $arr_data) . "\r\n";
                                    
                                $fones[$fone] = 1;
                            }
                        } 
                    }
                }
                
            }
        }

        fclose($handle); 

        $uuid = $Uuid->v4();

        $name_storage =  $uuid . '-' . time() . '.csv';
        
        $name_out = $this->config->item('path_storage') . $name_storage; 
        
        $handle_out = fopen($name_out, "wb");

        if (!is_array($output)) $output_file .= $output;
        
        else        
            foreach ($output as $column)
                $output_file .= $column;
                
        fwrite($handle_out, $output_file);

        if (fclose($handle_out)) {
            
            $arrData = array(
                basename($_FILES['file_csv']['name'], '.csv'),
                
                $phone_type,
                $order_by,
                ($add_zero? 1:0),
                
                basename($name_storage, '.csv'),
                $count,
                filesize($name_out),
                'csv'
                
            );

            
            $FileList = $this->load->library('FileList');

            $oFileList = new FileList();
            $oFileList->setDB($this->db);
            $oFileList->insert_file($arrData);
            
            // Header("Location: ?menu=$module_name");
            $http_response = array('success' => 'file uploaded');
            $this->response($http_response, REST_Controller::HTTP_OK);
        }

        $http_response = array('error' => 'internal server error');
        $this->response($http_response, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        
    }

    public function files_get() {

        $this->load->model('FilesModel');
        $res = $this->FilesModel->getFiles();

        $http_response = array(
            'data' => array (
                'type' => 'files',
                'count'  => $res['count'],
                'files' => $res['result']
            )
        );
        $http_code = REST_Controller::HTTP_OK;
        $this->response($http_response, $http_code);
    }

    public function files_delete() {
        $data = array(
            'id' => $this->get('id'),
        );

        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('id', 'ID', 'trim|required|integer|min_length[1]');
        if ($this->form_validation->run() == FALSE) {
            // TODO: acertar o erro
            $http_response = array(
                'data' => array (
                    'type' => 'files',
                    'error' => 'param missing',
                )
            );
            $http_code = REST_Controller::HTTP_METHOD_NOT_ALLOWED;
        } else {
            $this->load->model('FilesModel');

            $file = $this->FilesModel->getFile($data['id']);

            if (count($file) > 0) {
                $path = $this->config->item('path_storage') . $file['name_storage'] . '.' . $file['extension'];
                unlink($path);
            }

            $res = $this->FilesModel->deleteFile($data['id']);

            $http_response = array(
                'data' => array (
                    'type' => 'files',
                    'deleted' => $res
                )
            );
            $http_code = REST_Controller::HTTP_OK;
        }

        $this->response($http_response, $http_code);
    }

}
