#!/bin/bash

JWT_SECRET='jwt_secret=FkTFcWUsjrt-jKVAoBgsPgSfesLuWRbYXFlVQ4KMoaTeq4hDAz7_QwmBjiQCIdzEDzXSLFrIpZHiTyctCejTk_yPX_8Gf-q7hBoi1da2P-3K_rN2bI-shHqzZMULm3pqEQ_vmb6Cu6_O5B07R4_Mz2UkKxG7GZo7Kw8JjJj34KSfkouTF-OkDiyc-pKd3iz1JfmSXGIuREHaOd30HZDVJXOci9tJTv8u8KxiErHpWOi2NdgerFP5U4r1uWPOHS8S3b39T5xLmqT0zDCgDjvTTMdeHmMltUC39YEh5JrmzErmvYxBYBaVFfplUL2bsK8-UntaDRfB8XMf8I0e5Y5A0Q.'
PATH_WEB=/var/www/html
PATH_HTTPD=/etc/httpd
PATH_BACKUP_WEB=$PATH_BACKUP/web

PATH_PATCH_WEB=$PATH_PATCH/web
PATH_PATCH_WEB_MODULES=$PATH_PATCH_WEB/modules
PATH_PATCH_WEB_LANG=$PATH_PATCH_WEB/lang

_modules() {
    # create dir backup
    mkdir -p $PATH_BACKUP_WEB/modules

    for path in "$PATH_PATCH_WEB_MODULES"/*
    do
        filename=$(basename "$path" .tar.gz)
        if [ -d "$PATH_WEB/modules/$filename" ]; then
            # backup
            mv $PATH_WEB/modules/$filename $PATH_BACKUP_WEB/modules
        fi

        # cp $path $PATH_AGI/$filename
        # echo $path

        tar -zxf $path -C $PATH_WEB/modules
        
    done

    # set permission
    chown -R asterisk:asterisk $PATH_WEB/modules

    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} modulos do issabel foram atualizados."

}

_lang() {
# create dir backup
    mkdir -p $PATH_BACKUP_WEB/lang

    for path in "$PATH_PATCH_WEB_LANG"/*
    do
        filename=$(basename "$path")
        if [ -d "$PATH_WEB/lang/$filename" ]; then
            # backup
            mv $PATH_WEB/lang/$filename $PATH_BACKUP_WEB/lang
        fi

        # cp $path $PATH_AGI/$filename
        # echo $path

        cp $path $PATH_WEB/lang/$filename
        
    done

    # set permission
    chown -R asterisk:asterisk $PATH_WEB/lang

    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} idioma do issabel foi atualizados."

}

_ws() {
    # create dir backup
    mkdir -p $PATH_BACKUP_WEB

    mv $PATH_WEB/ws $PATH_BACKUP_WEB

    tar -zxf $PATH_PATCH_WEB/ws/ws.tar.gz -C $PATH_WEB
    # set permission
    chown -R asterisk:asterisk $PATH_WEB/ws

    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} api ws foi atualizados."

}

_httpd() {
    mkdir -p $PATH_BACKUP_WEB/httpd

    mv $PATH_HTTPD/conf.d/issabel.conf $PATH_BACKUP_WEB/httpd

    cp $PATH_PATCH_WEB/httpd/issabel.conf $PATH_HTTPD/conf.d/issabel.conf
    UUID=$(uuidgen)
    sed -i "s/SetEnv CI_ENV production/SetEnv CI_ENV production\n   SetEnv CI_JWTSECRET $UUID/" "$PATH_HTTPD/conf.d/issabel.conf"
    service httpd restart > /dev/null 2>&1

    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} httpd config foi atualizados."

    _jwt $UUID
}

_jwt() {
    yum install jq -y >> /dev/null 2>&1
    ./jwt.sh  -a HS256 -S  $JWT_SECRET$1 -p "{\"iss\":\"gvoip\", \"iat\":\"$(date +%s)\", \"client\":\"ws\", \"server\":\"prod\", \"gvid\":\"1.0.0\"}" > jwt-token.txt
    
    echo -e "${COLOR_GREEN_LIGHT}[OK]${COLOR_NC} token JWT gerado."
}



_web() {
    # _modules
    # _lang
    _ws
    _httpd
}