from flask import Flask, render_template, jsonify, request
import os
import pymysql
from colorama import init, Fore
import datetime

app = Flask(__name__)

conn = pymysql.connect(host='localhost', user='rbigols', password='32513683', database='consulta')
cursor = conn.cursor()

init(autoreset=True)

indexando = False

@app.route('/')
def index():
    return render_template('index.html')

@app.route('/indexar')
def indexar():
    global indexando
    
    print(Fore.CYAN + "Iniciando a indexação...")
    
    pasta_audios = os.path.join(os.path.dirname(__file__), 'audios')
    
    if not os.path.isdir(pasta_audios):
        return 'Pasta de áudios não encontrada.'
    
    indexando = True
    
    registros_a_inserir = []
    arquivos_verificados = set()
    
    cursor.execute("SELECT filepath FROM audio")
    resultados = cursor.fetchall()
    for resultado in resultados:
        arquivos_verificados.add(resultado[0])
    
    arquivos_nao_adicionados = []
    arquivos_ilegiveis = []
    arquivos_ocultos = []
    extensoes_contagem = {'.wav': 0, '.gsm': 0}
    
    for root, dirs, files in os.walk(pasta_audios):
        if not indexando:
            break
        
        for file in files:
            caminho_completo = os.path.join(root, file)
            
            # Contabilizando extensões de arquivo
            extensao = os.path.splitext(file)[1]
            if extensao in extensoes_contagem:
                extensoes_contagem[extensao] += 1
            
            if file.endswith(('.wav', '.gsm')):
                caminho_relativo = os.path.relpath(caminho_completo, pasta_audios)
                
                if caminho_relativo in arquivos_verificados:
                    continue
                    
                partes_caminho = caminho_relativo.split(os.sep)
                if len(partes_caminho) < 4:
                    continue
                
                servidor, ano, mes, dia, nome_arquivo = partes_caminho[:5]
                data_formatada = f"{ano}-{mes}-{dia}"
                
                caminho_arquivo = '/'.join(partes_caminho[1:])
                
                nome_arquivo = file
                caminho_arquivo = caminho_relativo
                print(Fore.YELLOW + f"NOVO: {caminho_relativo}")
                
                registros_a_inserir.append((servidor, data_formatada, nome_arquivo, caminho_arquivo))
            else:
                if not os.access(caminho_completo, os.R_OK):
                    arquivos_ilegiveis.append(caminho_completo)
                elif file.startswith('.'):
                    arquivos_ocultos.append(caminho_completo)
                else:
                    arquivos_nao_adicionados.append(caminho_completo)
    
    try:
        if registros_a_inserir:
            cursor.executemany("INSERT INTO audio (servidor, data, filename, filepath) VALUES (%s, %s, %s, %s)", registros_a_inserir)
            conn.commit()
            for registro in registros_a_inserir:
                print(Fore.GREEN + f"ADICIONADO: {registro[3]}")
            quantidade_inserida = len(registros_a_inserir)
        else:
            quantidade_inserida = 0
            
        print(Fore.YELLOW + f"Total adicionado na última execução: {quantidade_inserida}")
        
    except Exception as e:
        conn.rollback()
        quantidade_inserida = 0
    
    with open('log_total.txt', 'a', encoding='utf-8') as log_file:
        hora_atual = datetime.datetime.now().strftime("%H:%M:%S")
        log_file.write(f"Data e Hora: {hora_atual}\n")
        log_file.write(f"Extensão: .wav, Quantidade: {format(extensoes_contagem['.wav'], ',d').replace(',', '.')} \n")
        log_file.write(f"Extensão: .gsm, Quantidade: {format(extensoes_contagem['.gsm'], ',d').replace(',', '.')} \n")
        total_arquivos = extensoes_contagem['.wav'] + extensoes_contagem['.gsm']
        log_file.write(f"Total: {format(total_arquivos, ',d').replace(',', '.')} \n")
    
    print(Fore.GREEN + f"Extensão .wav, Quantidade: {format(extensoes_contagem['.wav'], ',d').replace(',', '.')}")
    print(Fore.GREEN + f"Extensão .gsm, Quantidade: {format(extensoes_contagem['.gsm'], ',d').replace(',', '.')}")
    print(Fore.GREEN + f"Total: {format(total_arquivos, ',d').replace(',', '.')}")
    
    indexando = False
    print(Fore.CYAN + "Indexação concluída.")
    return str(quantidade_inserida)

@app.route('/parar_indexacao', methods=['POST'])
def parar_indexacao():
    global indexando
    indexando = False
    return 'Indexação interrompida pelo usuário'

if __name__ == '__main__':
    app.run(debug=True)
