#!/bin/bash

# Install mongo driver php
yum -y install gcc php-pear php-devel

pecl install mongo

mv php.ini /etc/php.ini

service httpd restart

# Install docker and docker-compose
curl -fsSL https://get.docker.com/ | sh
systemctl start docker
systemctl status docker
systemctl enable docker
docker --version
curl -L "https://github.com/docker/compose/releases/download/1.23.2/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
chmod +x /usr/local/bin/docker-compose
docker-compose --version

# Docker-compose up
mkdir -p /opt/gvoip/docker
mv docker-compose.yml /opt/gvoip/docker
tar -zxf backup.tar.gz -C /opt/gvoip/docker
cd /opt/gvoip/docker
docker-compose up -d
#docker exec mongo-container mongorestore --username $1 --password $2 /backup/blacklistdb/*.bson
cd -

# Update discador e ura
killall -9 dialerd
killall -9 gvdialerd
chown asterisk:asterisk CampaignProcess.class.php.dia
chown asterisk:asterisk CampaignProcess.class.php.ura
chown asterisk:asterisk blacklist.php
mv /opt/issabel/dialer/CampaignProcess.class.php /opt/issabel/dialer/CampaignProcess.class.php.old
mv CampaignProcess.class.php.dia /opt/issabel/dialer/CampaignProcess.class.php
mv /opt/issabel/campaign/CampaignProcess.class.php /opt/issabel/campaign/CampaignProcess.class.php.old
mv CampaignProcess.class.php.ura /opt/issabel/campaign/CampaignProcess.class.php
mv blacklist.php /var/lib/asterisk/agi-bin
service issabeldialer start
service gvoipdialer start
